/*
 * Copyright (C) 2005-2008 MaNGOS <http://www.mangosproject.org/>
 *
 * Copyright (C) 2008 Trinity <http://www.trinitycore.org/>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/** \file
    \ingroup u2w
*/

#include "Opcodes.h"
#include "WorldSession.h"

/// Correspondence between opcodes and their names
OpcodeHandler opcodeTable[NUM_MSG_TYPES] =
{
    /*0x000*/ { "MSG_NULL_ACTION",                  STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x001*/ { "CMSG_BOOTME",                      STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x002*/ { "CMSG_DBLOOKUP",                    STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x003*/ { "SMSG_DBLOOKUP",                    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x004*/ { "CMSG_QUERY_OBJECT_POSITION",       STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x005*/ { "SMSG_QUERY_OBJECT_POSITION",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x006*/ { "CMSG_QUERY_OBJECT_ROTATION",       STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x007*/ { "SMSG_QUERY_OBJECT_ROTATION",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x008*/ { "CMSG_WORLD_TELEPORT",              STATUS_LOGGEDIN, &WorldSession::HandleWorldTeleportOpcode       },
    /*0x009*/ { "CMSG_TELEPORT_TO_UNIT",            STATUS_LOGGEDIN, &WorldSession::Handle_NULL                     },
    /*0x00A*/ { "CMSG_ZONE_MAP",                    STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x00B*/ { "SMSG_ZONE_MAP",                    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x00C*/ { "CMSG_DEBUG_CHANGECELLZONE",        STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x00D*/ { "CMSG_EMBLAZON_TABARD_OBSOLETE",    STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x00E*/ { "CMSG_UNEMBLAZON_TABARD_OBSOLETE",  STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x00F*/ { "CMSG_RECHARGE",                    STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x010*/ { "CMSG_LEARN_SPELL",                 STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x011*/ { "CMSG_CREATEMONSTER",               STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x012*/ { "CMSG_DESTROYMONSTER",              STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x013*/ { "CMSG_CREATEITEM",                  STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x014*/ { "CMSG_CREATEGAMEOBJECT",            STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x015*/ { "SMSG_CHECK_FOR_BOTS",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x016*/ { "CMSG_MAKEMONSTERATTACKGUID",       STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x017*/ { "CMSG_BOT_DETECTED2",               STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x018*/ { "CMSG_FORCEACTION",                 STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x019*/ { "CMSG_FORCEACTIONONOTHER",          STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x01A*/ { "CMSG_FORCEACTIONSHOW",             STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x01B*/ { "SMSG_FORCEACTIONSHOW",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x01C*/ { "CMSG_PETGODMODE",                  STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x01D*/ { "SMSG_PETGODMODE",                  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x01E*/ { "SMSG_DEBUGINFOSPELLMISS_OBSOLETE", STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x01F*/ { "CMSG_WEATHER_SPEED_CHEAT",         STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x020*/ { "CMSG_UNDRESSPLAYER",               STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x021*/ { "CMSG_BEASTMASTER",                 STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x022*/ { "CMSG_GODMODE",                     STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x023*/ { "SMSG_GODMODE",                     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x024*/ { "CMSG_CHEAT_SETMONEY",              STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x025*/ { "CMSG_LEVEL_CHEAT",                 STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x026*/ { "CMSG_PET_LEVEL_CHEAT",             STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x027*/ { "CMSG_SET_WORLDSTATE",              STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x028*/ { "CMSG_COOLDOWN_CHEAT",              STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x029*/ { "CMSG_USE_SKILL_CHEAT",             STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x02A*/ { "CMSG_FLAG_QUEST",                  STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x02B*/ { "CMSG_FLAG_QUEST_FINISH",           STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x02C*/ { "CMSG_CLEAR_QUEST",                 STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x02D*/ { "CMSG_SEND_EVENT",                  STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x02E*/ { "CMSG_DEBUG_AISTATE",               STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x02F*/ { "SMSG_DEBUG_AISTATE",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x030*/ { "CMSG_DISABLE_PVP_CHEAT",           STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x031*/ { "CMSG_ADVANCE_SPAWN_TIME",          STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x032*/ { "CMSG_PVP_PORT_OBSOLETE",           STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x033*/ { "CMSG_AUTH_SRP6_BEGIN",             STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x034*/ { "CMSG_AUTH_SRP6_PROOF",             STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x035*/ { "CMSG_AUTH_SRP6_RECODE",            STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x036*/ { "CMSG_CHAR_CREATE",                 STATUS_AUTHED,   &WorldSession::HandleCharCreateOpcode          },
    /*0x037*/ { "CMSG_CHAR_ENUM",                   STATUS_AUTHED,   &WorldSession::HandleCharEnumOpcode            },
    /*0x038*/ { "CMSG_CHAR_DELETE",                 STATUS_AUTHED,   &WorldSession::HandleCharDeleteOpcode          },
    /*0x039*/ { "SMSG_AUTH_SRP6_RESPONSE",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x03A*/ { "SMSG_CHAR_CREATE",                 STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x03B*/ { "SMSG_CHAR_ENUM",                   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x03C*/ { "SMSG_CHAR_DELETE",                 STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x03D*/ { "CMSG_PLAYER_LOGIN",                STATUS_AUTHED,   &WorldSession::HandlePlayerLoginOpcode         },
    /*0x03E*/ { "SMSG_NEW_WORLD",                   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x03F*/ { "SMSG_TRANSFER_PENDING",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x040*/ { "SMSG_TRANSFER_ABORTED",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x041*/ { "SMSG_CHARACTER_LOGIN_FAILED",      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x042*/ { "SMSG_LOGIN_SETTIMESPEED",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x043*/ { "SMSG_GAMETIME_UPDATE",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x044*/ { "CMSG_GAMETIME_SET",                STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x045*/ { "SMSG_GAMETIME_SET",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x046*/ { "CMSG_GAMESPEED_SET",               STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x047*/ { "SMSG_GAMESPEED_SET",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x048*/ { "CMSG_SERVERTIME",                  STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x049*/ { "SMSG_SERVERTIME",                  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x04A*/ { "CMSG_PLAYER_LOGOUT",               STATUS_LOGGEDIN, &WorldSession::HandlePlayerLogoutOpcode        },
    /*0x04B*/ { "CMSG_LOGOUT_REQUEST",              STATUS_LOGGEDIN, &WorldSession::HandleLogoutRequestOpcode       },
    /*0x04C*/ { "SMSG_LOGOUT_RESPONSE",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x04D*/ { "SMSG_LOGOUT_COMPLETE",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x04E*/ { "CMSG_LOGOUT_CANCEL",               STATUS_LOGGEDIN, &WorldSession::HandleLogoutCancelOpcode        },
    /*0x04F*/ { "SMSG_LOGOUT_CANCEL_ACK",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x050*/ { "CMSG_NAME_QUERY",                  STATUS_LOGGEDIN, &WorldSession::HandleNameQueryOpcode           },
    /*0x051*/ { "SMSG_NAME_QUERY_RESPONSE",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x052*/ { "CMSG_PET_NAME_QUERY",              STATUS_LOGGEDIN, &WorldSession::HandlePetNameQuery              },
    /*0x053*/ { "SMSG_PET_NAME_QUERY_RESPONSE",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x054*/ { "CMSG_GUILD_QUERY",                 STATUS_AUTHED,   &WorldSession::HandleGuildQueryOpcode          },
    /*0x055*/ { "SMSG_GUILD_QUERY_RESPONSE",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x056*/ { "CMSG_ITEM_QUERY_SINGLE",           STATUS_LOGGEDIN, &WorldSession::HandleItemQuerySingleOpcode     },
    /*0x057*/ { "CMSG_ITEM_QUERY_MULTIPLE",         STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x058*/ { "SMSG_ITEM_QUERY_SINGLE_RESPONSE",  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x059*/ { "SMSG_ITEM_QUERY_MULTIPLE_RESPONSE",STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x05A*/ { "CMSG_PAGE_TEXT_QUERY",             STATUS_LOGGEDIN, &WorldSession::HandlePageQueryOpcode           },
    /*0x05B*/ { "SMSG_PAGE_TEXT_QUERY_RESPONSE",    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x05C*/ { "CMSG_QUEST_QUERY",                 STATUS_LOGGEDIN, &WorldSession::HandleQuestQueryOpcode          },
    /*0x05D*/ { "SMSG_QUEST_QUERY_RESPONSE",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x05E*/ { "CMSG_GAMEOBJECT_QUERY",            STATUS_LOGGEDIN, &WorldSession::HandleGameObjectQueryOpcode     },
    /*0x05F*/ { "SMSG_GAMEOBJECT_QUERY_RESPONSE",   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x060*/ { "CMSG_CREATURE_QUERY",              STATUS_LOGGEDIN, &WorldSession::HandleCreatureQueryOpcode       },
    /*0x061*/ { "SMSG_CREATURE_QUERY_RESPONSE",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x062*/ { "CMSG_WHO",                         STATUS_LOGGEDIN, &WorldSession::HandleWhoOpcode                 },
    /*0x063*/ { "SMSG_WHO",                         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x064*/ { "CMSG_WHOIS",                       STATUS_LOGGEDIN, &WorldSession::HandleWhoisOpcode               },
    /*0x065*/ { "SMSG_WHOIS",                       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x066*/ { "CMSG_CONTACT_LIST",                STATUS_LOGGEDIN, &WorldSession::HandleFriendListOpcode          },
    /*0x067*/ { "SMSG_CONTACT_LIST",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x068*/ { "SMSG_FRIEND_STATUS",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x069*/ { "CMSG_ADD_FRIEND",                  STATUS_LOGGEDIN, &WorldSession::HandleAddFriendOpcode           },
    /*0x06A*/ { "CMSG_DEL_FRIEND",                  STATUS_LOGGEDIN, &WorldSession::HandleDelFriendOpcode           },
    /*0x06B*/ { "CMSG_SET_CONTACT_NOTES",           STATUS_LOGGEDIN, &WorldSession::HandleSetFriendNoteOpcode       },
    /*0x06C*/ { "CMSG_ADD_IGNORE",                  STATUS_LOGGEDIN, &WorldSession::HandleAddIgnoreOpcode           },
    /*0x06D*/ { "CMSG_DEL_IGNORE",                  STATUS_LOGGEDIN, &WorldSession::HandleDelIgnoreOpcode           },
    /*0x06E*/ { "CMSG_GROUP_INVITE",                STATUS_LOGGEDIN, &WorldSession::HandleGroupInviteOpcode         },
    /*0x06F*/ { "SMSG_GROUP_INVITE",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x070*/ { "CMSG_GROUP_CANCEL",                STATUS_LOGGEDIN, &WorldSession::Handle_Depricated               },
    /*0x071*/ { "SMSG_GROUP_CANCEL",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x072*/ { "CMSG_GROUP_ACCEPT",                STATUS_LOGGEDIN, &WorldSession::HandleGroupAcceptOpcode         },
    /*0x073*/ { "CMSG_GROUP_DECLINE",               STATUS_LOGGEDIN, &WorldSession::HandleGroupDeclineOpcode        },
    /*0x074*/ { "SMSG_GROUP_DECLINE",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x075*/ { "CMSG_GROUP_UNINVITE",              STATUS_LOGGEDIN, &WorldSession::HandleGroupUninviteNameOpcode   },
    /*0x076*/ { "CMSG_GROUP_UNINVITE_GUID",         STATUS_LOGGEDIN, &WorldSession::HandleGroupUninviteGuidOpcode   },
    /*0x077*/ { "SMSG_GROUP_UNINVITE",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x078*/ { "CMSG_GROUP_SET_LEADER",            STATUS_LOGGEDIN, &WorldSession::HandleGroupSetLeaderOpcode      },
    /*0x079*/ { "SMSG_GROUP_SET_LEADER",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x07A*/ { "CMSG_LOOT_METHOD",                 STATUS_LOGGEDIN, &WorldSession::HandleLootMethodOpcode          },
    /*0x07B*/ { "CMSG_GROUP_DISBAND",               STATUS_LOGGEDIN, &WorldSession::HandleGroupLeaveOpcode          },
    /*0x07C*/ { "SMSG_GROUP_DESTROYED",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x07D*/ { "SMSG_GROUP_LIST",                  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x07E*/ { "SMSG_PARTY_MEMBER_STATS",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x07F*/ { "SMSG_PARTY_COMMAND_RESULT",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x080*/ { "UMSG_UPDATE_GROUP_MEMBERS",        STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x081*/ { "CMSG_GUILD_CREATE",                STATUS_LOGGEDIN, &WorldSession::HandleGuildCreateOpcode         },
    /*0x082*/ { "CMSG_GUILD_INVITE",                STATUS_LOGGEDIN, &WorldSession::HandleGuildInviteOpcode         },
    /*0x083*/ { "SMSG_GUILD_INVITE",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x084*/ { "CMSG_GUILD_ACCEPT",                STATUS_LOGGEDIN, &WorldSession::HandleGuildAcceptOpcode         },
    /*0x085*/ { "CMSG_GUILD_DECLINE",               STATUS_LOGGEDIN, &WorldSession::HandleGuildDeclineOpcode        },
    /*0x086*/ { "SMSG_GUILD_DECLINE",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x087*/ { "CMSG_GUILD_INFO",                  STATUS_LOGGEDIN, &WorldSession::HandleGuildInfoOpcode           },
    /*0x088*/ { "SMSG_GUILD_INFO",                  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x089*/ { "CMSG_GUILD_ROSTER",                STATUS_LOGGEDIN, &WorldSession::HandleGuildRosterOpcode         },
    /*0x08A*/ { "SMSG_GUILD_ROSTER",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x08B*/ { "CMSG_GUILD_PROMOTE",               STATUS_LOGGEDIN, &WorldSession::HandleGuildPromoteOpcode        },
    /*0x08C*/ { "CMSG_GUILD_DEMOTE",                STATUS_LOGGEDIN, &WorldSession::HandleGuildDemoteOpcode         },
    /*0x08D*/ { "CMSG_GUILD_LEAVE",                 STATUS_LOGGEDIN, &WorldSession::HandleGuildLeaveOpcode          },
    /*0x08E*/ { "CMSG_GUILD_REMOVE",                STATUS_LOGGEDIN, &WorldSession::HandleGuildRemoveOpcode         },
    /*0x08F*/ { "CMSG_GUILD_DISBAND",               STATUS_LOGGEDIN, &WorldSession::HandleGuildDisbandOpcode        },
    /*0x090*/ { "CMSG_GUILD_LEADER",                STATUS_LOGGEDIN, &WorldSession::HandleGuildLeaderOpcode         },
    /*0x091*/ { "CMSG_GUILD_MOTD",                  STATUS_LOGGEDIN, &WorldSession::HandleGuildMOTDOpcode           },
    /*0x092*/ { "SMSG_GUILD_EVENT",                 STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x093*/ { "SMSG_GUILD_COMMAND_RESULT",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x094*/ { "UMSG_UPDATE_GUILD",                STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x095*/ { "CMSG_MESSAGECHAT",                 STATUS_LOGGEDIN, &WorldSession::HandleMessagechatOpcode         },
    /*0x096*/ { "SMSG_MESSAGECHAT",                 STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x097*/ { "CMSG_JOIN_CHANNEL",                STATUS_LOGGEDIN, &WorldSession::HandleChannelJoin               },
    /*0x098*/ { "CMSG_LEAVE_CHANNEL",               STATUS_LOGGEDIN, &WorldSession::HandleChannelLeave              },
    /*0x099*/ { "SMSG_CHANNEL_NOTIFY",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x09A*/ { "CMSG_CHANNEL_LIST",                STATUS_LOGGEDIN, &WorldSession::HandleChannelList               },
    /*0x09B*/ { "SMSG_CHANNEL_LIST",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x09C*/ { "CMSG_CHANNEL_PASSWORD",            STATUS_LOGGEDIN, &WorldSession::HandleChannelPassword           },
    /*0x09D*/ { "CMSG_CHANNEL_SET_OWNER",           STATUS_LOGGEDIN, &WorldSession::HandleChannelSetOwner           },
    /*0x09E*/ { "CMSG_CHANNEL_OWNER",               STATUS_LOGGEDIN, &WorldSession::HandleChannelOwner              },
    /*0x09F*/ { "CMSG_CHANNEL_MODERATOR",           STATUS_LOGGEDIN, &WorldSession::HandleChannelModerator          },
    /*0x0A0*/ { "CMSG_CHANNEL_UNMODERATOR",         STATUS_LOGGEDIN, &WorldSession::HandleChannelUnmoderator        },
    /*0x0A1*/ { "CMSG_CHANNEL_MUTE",                STATUS_LOGGEDIN, &WorldSession::HandleChannelMute               },
    /*0x0A2*/ { "CMSG_CHANNEL_UNMUTE",              STATUS_LOGGEDIN, &WorldSession::HandleChannelUnmute             },
    /*0x0A3*/ { "CMSG_CHANNEL_INVITE",              STATUS_LOGGEDIN, &WorldSession::HandleChannelInvite             },
    /*0x0A4*/ { "CMSG_CHANNEL_KICK",                STATUS_LOGGEDIN, &WorldSession::HandleChannelKick               },
    /*0x0A5*/ { "CMSG_CHANNEL_BAN",                 STATUS_LOGGEDIN, &WorldSession::HandleChannelBan                },
    /*0x0A6*/ { "CMSG_CHANNEL_UNBAN",               STATUS_LOGGEDIN, &WorldSession::HandleChannelUnban              },
    /*0x0A7*/ { "CMSG_CHANNEL_ANNOUNCEMENTS",       STATUS_LOGGEDIN, &WorldSession::HandleChannelAnnounce           },
    /*0x0A8*/ { "CMSG_CHANNEL_MODERATE",            STATUS_LOGGEDIN, &WorldSession::HandleChannelModerate           },
    /*0x0A9*/ { "SMSG_UPDATE_OBJECT",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x0AA*/ { "SMSG_DESTROY_OBJECT",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x0AB*/ { "CMSG_USE_ITEM",                    STATUS_LOGGEDIN, &WorldSession::HandleUseItemOpcode             },
    /*0x0AC*/ { "CMSG_OPEN_ITEM",                   STATUS_LOGGEDIN, &WorldSession::HandleOpenItemOpcode            },
    /*0x0AD*/ { "CMSG_READ_ITEM",                   STATUS_LOGGEDIN, &WorldSession::HandleReadItem                  },
    /*0x0AE*/ { "SMSG_READ_ITEM_OK",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x0AF*/ { "SMSG_READ_ITEM_FAILED",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x0B0*/ { "SMSG_ITEM_COOLDOWN",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x0B1*/ { "CMSG_GAMEOBJ_USE",                 STATUS_LOGGEDIN, &WorldSession::HandleGameObjectUseOpcode       },
    /*0x0B2*/ { "CMSG_GAMEOBJ_CHAIR_USE_OBSOLETE",  STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0B3*/ { "SMSG_GAMEOBJECT_CUSTOM_ANIM",      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x0B4*/ { "CMSG_AREATRIGGER",                 STATUS_LOGGEDIN, &WorldSession::HandleAreaTriggerOpcode         },
    /*0x0B5*/ { "MSG_MOVE_START_FORWARD",           STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x0B6*/ { "MSG_MOVE_START_BACKWARD",          STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x0B7*/ { "MSG_MOVE_STOP",                    STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x0B8*/ { "MSG_MOVE_START_STRAFE_LEFT",       STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x0B9*/ { "MSG_MOVE_START_STRAFE_RIGHT",      STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x0BA*/ { "MSG_MOVE_STOP_STRAFE",             STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x0BB*/ { "MSG_MOVE_JUMP",                    STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x0BC*/ { "MSG_MOVE_START_TURN_LEFT",         STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x0BD*/ { "MSG_MOVE_START_TURN_RIGHT",        STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x0BE*/ { "MSG_MOVE_STOP_TURN",               STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x0BF*/ { "MSG_MOVE_START_PITCH_UP",          STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x0C0*/ { "MSG_MOVE_START_PITCH_DOWN",        STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x0C1*/ { "MSG_MOVE_STOP_PITCH",              STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x0C2*/ { "MSG_MOVE_SET_RUN_MODE",            STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x0C3*/ { "MSG_MOVE_SET_WALK_MODE",           STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x0C4*/ { "MSG_MOVE_TOGGLE_LOGGING",          STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0C5*/ { "MSG_MOVE_TELEPORT",                STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0C6*/ { "MSG_MOVE_TELEPORT_CHEAT",          STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0C7*/ { "MSG_MOVE_TELEPORT_ACK",            STATUS_LOGGEDIN, &WorldSession::HandleMoveTeleportAck           },
    /*0x0C8*/ { "MSG_MOVE_TOGGLE_FALL_LOGGING",     STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0C9*/ { "MSG_MOVE_FALL_LAND",               STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x0CA*/ { "MSG_MOVE_START_SWIM",              STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x0CB*/ { "MSG_MOVE_STOP_SWIM",               STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x0CC*/ { "MSG_MOVE_SET_RUN_SPEED_CHEAT",     STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0CD*/ { "MSG_MOVE_SET_RUN_SPEED",           STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0CE*/ { "MSG_MOVE_SET_RUN_BACK_SPEED_CHEAT",STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0CF*/ { "MSG_MOVE_SET_RUN_BACK_SPEED",      STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0D0*/ { "MSG_MOVE_SET_WALK_SPEED_CHEAT",    STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0D1*/ { "MSG_MOVE_SET_WALK_SPEED",          STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0D2*/ { "MSG_MOVE_SET_SWIM_SPEED_CHEAT",    STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0D3*/ { "MSG_MOVE_SET_SWIM_SPEED",          STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0D4*/ { "MSG_MOVE_SET_SWIM_BACK_SPEED_CHEAT",STATUS_NEVER,   &WorldSession::Handle_NULL                     },
    /*0x0D5*/ { "MSG_MOVE_SET_SWIM_BACK_SPEED",     STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0D6*/ { "MSG_MOVE_SET_ALL_SPEED_CHEAT",     STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0D7*/ { "MSG_MOVE_SET_TURN_RATE_CHEAT",     STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0D8*/ { "MSG_MOVE_SET_TURN_RATE",           STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0D9*/ { "MSG_MOVE_TOGGLE_COLLISION_CHEAT",  STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0DA*/ { "MSG_MOVE_SET_FACING",              STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x0DB*/ { "MSG_MOVE_SET_PITCH",               STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x0DC*/ { "MSG_MOVE_WORLDPORT_ACK",           STATUS_TRANSFER_PENDING, &WorldSession::HandleMoveWorldportAckOpcode},
    /*0x0DD*/ { "SMSG_MONSTER_MOVE",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x0DE*/ { "SMSG_MOVE_WATER_WALK",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x0DF*/ { "SMSG_MOVE_LAND_WALK",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x0E0*/ { "MSG_MOVE_SET_RAW_POSITION_ACK",    STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0E1*/ { "CMSG_MOVE_SET_RAW_POSITION",       STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0E2*/ { "SMSG_FORCE_RUN_SPEED_CHANGE",      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x0E3*/ { "CMSG_FORCE_RUN_SPEED_CHANGE_ACK",  STATUS_LOGGEDIN, &WorldSession::HandleForceSpeedChangeAck       },
    /*0x0E4*/ { "SMSG_FORCE_RUN_BACK_SPEED_CHANGE", STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x0E5*/ { "CMSG_FORCE_RUN_BACK_SPEED_CHANGE_ACK",STATUS_LOGGEDIN,&WorldSession::HandleForceSpeedChangeAck     },
    /*0x0E6*/ { "SMSG_FORCE_SWIM_SPEED_CHANGE",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x0E7*/ { "CMSG_FORCE_SWIM_SPEED_CHANGE_ACK", STATUS_LOGGEDIN, &WorldSession::HandleForceSpeedChangeAck       },
    /*0x0E8*/ { "SMSG_FORCE_MOVE_ROOT",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x0E9*/ { "CMSG_FORCE_MOVE_ROOT_ACK",         STATUS_LOGGEDIN, &WorldSession::HandleMoveRootAck               },
    /*0x0EA*/ { "SMSG_FORCE_MOVE_UNROOT",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x0EB*/ { "CMSG_FORCE_MOVE_UNROOT_ACK",       STATUS_LOGGEDIN, &WorldSession::HandleMoveUnRootAck             },
    /*0x0EC*/ { "MSG_MOVE_ROOT",                    STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0ED*/ { "MSG_MOVE_UNROOT",                  STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0EE*/ { "MSG_MOVE_HEARTBEAT",               STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x0EF*/ { "SMSG_MOVE_KNOCK_BACK",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x0F0*/ { "CMSG_MOVE_KNOCK_BACK_ACK",         STATUS_LOGGEDIN, &WorldSession::HandleMoveKnockBackAck          },
    /*0x0F1*/ { "MSG_MOVE_KNOCK_BACK",              STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0F2*/ { "SMSG_MOVE_FEATHER_FALL",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x0F3*/ { "SMSG_MOVE_NORMAL_FALL",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x0F4*/ { "SMSG_MOVE_SET_HOVER",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x0F5*/ { "SMSG_MOVE_UNSET_HOVER",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x0F6*/ { "CMSG_MOVE_HOVER_ACK",              STATUS_LOGGEDIN, &WorldSession::HandleMoveHoverAck              },
    /*0x0F7*/ { "MSG_MOVE_HOVER",                   STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0F8*/ { "CMSG_TRIGGER_CINEMATIC_CHEAT",     STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0F9*/ { "CMSG_OPENING_CINEMATIC",           STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x0FA*/ { "SMSG_TRIGGER_CINEMATIC",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x0FB*/ { "CMSG_NEXT_CINEMATIC_CAMERA",       STATUS_LOGGEDIN, &WorldSession::HandleNextCinematicCamera       },
    /*0x0FC*/ { "CMSG_COMPLETE_CINEMATIC",          STATUS_LOGGEDIN, &WorldSession::HandleCompleteCinema            },
    /*0x0FD*/ { "SMSG_TUTORIAL_FLAGS",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x0FE*/ { "CMSG_TUTORIAL_FLAG",               STATUS_LOGGEDIN, &WorldSession::HandleTutorialFlag              },
    /*0x0FF*/ { "CMSG_TUTORIAL_CLEAR",              STATUS_LOGGEDIN, &WorldSession::HandleTutorialClear             },
    /*0x100*/ { "CMSG_TUTORIAL_RESET",              STATUS_LOGGEDIN, &WorldSession::HandleTutorialReset             },
    /*0x101*/ { "CMSG_STANDSTATECHANGE",            STATUS_LOGGEDIN, &WorldSession::HandleStandStateChangeOpcode    },
    /*0x102*/ { "CMSG_EMOTE",                       STATUS_LOGGEDIN, &WorldSession::HandleEmoteOpcode               },
    /*0x103*/ { "SMSG_EMOTE",                       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x104*/ { "CMSG_TEXT_EMOTE",                  STATUS_LOGGEDIN, &WorldSession::HandleTextEmoteOpcode           },
    /*0x105*/ { "SMSG_TEXT_EMOTE",                  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x106*/ { "CMSG_AUTOEQUIP_GROUND_ITEM",       STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x107*/ { "CMSG_AUTOSTORE_GROUND_ITEM",       STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x108*/ { "CMSG_AUTOSTORE_LOOT_ITEM",         STATUS_LOGGEDIN, &WorldSession::HandleAutostoreLootItemOpcode   },
    /*0x109*/ { "CMSG_STORE_LOOT_IN_SLOT",          STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x10A*/ { "CMSG_AUTOEQUIP_ITEM",              STATUS_LOGGEDIN, &WorldSession::HandleAutoEquipItemOpcode       },
    /*0x10B*/ { "CMSG_AUTOSTORE_BAG_ITEM",          STATUS_LOGGEDIN, &WorldSession::HandleAutoStoreBagItemOpcode    },
    /*0x10C*/ { "CMSG_SWAP_ITEM",                   STATUS_LOGGEDIN, &WorldSession::HandleSwapItem                  },
    /*0x10D*/ { "CMSG_SWAP_INV_ITEM",               STATUS_LOGGEDIN, &WorldSession::HandleSwapInvItemOpcode         },
    /*0x10E*/ { "CMSG_SPLIT_ITEM",                  STATUS_LOGGEDIN, &WorldSession::HandleSplitItemOpcode           },
    /*0x10F*/ { "CMSG_AUTOEQUIP_ITEM_SLOT",         STATUS_LOGGEDIN, &WorldSession::HandleAutoEquipItemSlotOpcode   },
    /*0x110*/ { "OBSOLETE_DROP_ITEM",               STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x111*/ { "CMSG_DESTROYITEM",                 STATUS_LOGGEDIN, &WorldSession::HandleDestroyItemOpcode         },
    /*0x112*/ { "SMSG_INVENTORY_CHANGE_FAILURE",    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x113*/ { "SMSG_OPEN_CONTAINER",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x114*/ { "CMSG_INSPECT",                     STATUS_LOGGEDIN, &WorldSession::HandleInspectOpcode             },
    /*0x115*/ { "SMSG_INSPECT",                     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x116*/ { "CMSG_INITIATE_TRADE",              STATUS_LOGGEDIN, &WorldSession::HandleInitiateTradeOpcode       },
    /*0x117*/ { "CMSG_BEGIN_TRADE",                 STATUS_LOGGEDIN, &WorldSession::HandleBeginTradeOpcode          },
    /*0x118*/ { "CMSG_BUSY_TRADE",                  STATUS_LOGGEDIN, &WorldSession::HandleBusyTradeOpcode           },
    /*0x119*/ { "CMSG_IGNORE_TRADE",                STATUS_LOGGEDIN, &WorldSession::HandleIgnoreTradeOpcode         },
    /*0x11A*/ { "CMSG_ACCEPT_TRADE",                STATUS_LOGGEDIN, &WorldSession::HandleAcceptTradeOpcode         },
    /*0x11B*/ { "CMSG_UNACCEPT_TRADE",              STATUS_LOGGEDIN, &WorldSession::HandleUnacceptTradeOpcode       },
    /*0x11C*/ { "CMSG_CANCEL_TRADE",                STATUS_AUTHED,   &WorldSession::HandleCancelTradeOpcode         },
                                                            // also send after logout complete
    /*0x11D*/ { "CMSG_SET_TRADE_ITEM",              STATUS_LOGGEDIN, &WorldSession::HandleSetTradeItemOpcode        },
    /*0x11E*/ { "CMSG_CLEAR_TRADE_ITEM",            STATUS_LOGGEDIN, &WorldSession::HandleClearTradeItemOpcode      },
    /*0x11F*/ { "CMSG_SET_TRADE_GOLD",              STATUS_LOGGEDIN, &WorldSession::HandleSetTradeGoldOpcode        },
    /*0x120*/ { "SMSG_TRADE_STATUS",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x121*/ { "SMSG_TRADE_STATUS_EXTENDED",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x122*/ { "SMSG_INITIALIZE_FACTIONS",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x123*/ { "SMSG_SET_FACTION_VISIBLE",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x124*/ { "SMSG_SET_FACTION_STANDING",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x125*/ { "CMSG_SET_FACTION_ATWAR",           STATUS_LOGGEDIN, &WorldSession::HandleSetFactionAtWar           },
    /*0x126*/ { "CMSG_SET_FACTION_CHEAT",           STATUS_LOGGEDIN, &WorldSession::HandleSetFactionCheat           },
    /*0x127*/ { "SMSG_SET_PROFICIENCY",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x128*/ { "CMSG_SET_ACTION_BUTTON",           STATUS_LOGGEDIN, &WorldSession::HandleSetActionButtonOpcode     },
    /*0x129*/ { "SMSG_ACTION_BUTTONS",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x12A*/ { "SMSG_INITIAL_SPELLS",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x12B*/ { "SMSG_LEARNED_SPELL",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x12C*/ { "SMSG_SUPERCEDED_SPELL",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x12D*/ { "CMSG_NEW_SPELL_SLOT",              STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x12E*/ { "CMSG_CAST_SPELL",                  STATUS_LOGGEDIN, &WorldSession::HandleCastSpellOpcode           },
    /*0x12F*/ { "CMSG_CANCEL_CAST",                 STATUS_LOGGEDIN, &WorldSession::HandleCancelCastOpcode          },
    /*0x130*/ { "SMSG_CAST_FAILED",                 STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x131*/ { "SMSG_SPELL_START",                 STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x132*/ { "SMSG_SPELL_GO",                    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x133*/ { "SMSG_SPELL_FAILURE",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x134*/ { "SMSG_SPELL_COOLDOWN",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x135*/ { "SMSG_COOLDOWN_EVENT",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x136*/ { "CMSG_CANCEL_AURA",                 STATUS_LOGGEDIN, &WorldSession::HandleCancelAuraOpcode          },
    /*0x137*/ { "SMSG_UPDATE_AURA_DURATION",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x138*/ { "SMSG_PET_CAST_FAILED",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x139*/ { "MSG_CHANNEL_START",                STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x13A*/ { "MSG_CHANNEL_UPDATE",               STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x13B*/ { "CMSG_CANCEL_CHANNELLING",          STATUS_LOGGEDIN, &WorldSession::HandleCancelChanneling          },
    /*0x13C*/ { "SMSG_AI_REACTION",                 STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x13D*/ { "CMSG_SET_SELECTION",               STATUS_LOGGEDIN, &WorldSession::HandleSetSelectionOpcode        },
    /*0x13E*/ { "CMSG_SET_TARGET_OBSOLETE",         STATUS_LOGGEDIN, &WorldSession::HandleSetTargetOpcode           },
    /*0x13F*/ { "CMSG_UNUSED",                      STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x140*/ { "CMSG_UNUSED2",                     STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x141*/ { "CMSG_ATTACKSWING",                 STATUS_LOGGEDIN, &WorldSession::HandleAttackSwingOpcode         },
    /*0x142*/ { "CMSG_ATTACKSTOP",                  STATUS_LOGGEDIN, &WorldSession::HandleAttackStopOpcode          },
    /*0x143*/ { "SMSG_ATTACKSTART",                 STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x144*/ { "SMSG_ATTACKSTOP",                  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x145*/ { "SMSG_ATTACKSWING_NOTINRANGE",      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x146*/ { "SMSG_ATTACKSWING_BADFACING",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x147*/ { "SMSG_ATTACKSWING_NOTSTANDING",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x148*/ { "SMSG_ATTACKSWING_DEADTARGET",      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x149*/ { "SMSG_ATTACKSWING_CANT_ATTACK",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x14A*/ { "SMSG_ATTACKERSTATEUPDATE",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x14B*/ { "SMSG_VICTIMSTATEUPDATE_OBSOLETE",  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x14C*/ { "SMSG_DAMAGE_DONE_OBSOLETE",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x14D*/ { "SMSG_DAMAGE_TAKEN_OBSOLETE",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x14E*/ { "SMSG_CANCEL_COMBAT",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x14F*/ { "SMSG_PLAYER_COMBAT_XP_GAIN_OBSOLETE",STATUS_NEVER,  &WorldSession::Handle_ServerSide               },
    /*0x150*/ { "SMSG_SPELLHEALLOG",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x151*/ { "SMSG_SPELLENERGIZELOG",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x152*/ { "CMSG_SHEATHE_OBSOLETE",            STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x153*/ { "CMSG_SAVE_PLAYER",                 STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x154*/ { "CMSG_SETDEATHBINDPOINT",           STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x155*/ { "SMSG_BINDPOINTUPDATE",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x156*/ { "CMSG_GETDEATHBINDZONE",            STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x157*/ { "SMSG_BINDZONEREPLY",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x158*/ { "SMSG_PLAYERBOUND",                 STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x159*/ { "SMSG_CLIENT_CONTROL_UPDATE",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x15A*/ { "CMSG_REPOP_REQUEST",               STATUS_LOGGEDIN, &WorldSession::HandleRepopRequestOpcode        },
    /*0x15B*/ { "SMSG_RESURRECT_REQUEST",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x15C*/ { "CMSG_RESURRECT_RESPONSE",          STATUS_LOGGEDIN, &WorldSession::HandleResurrectResponseOpcode   },
    /*0x15D*/ { "CMSG_LOOT",                        STATUS_LOGGEDIN, &WorldSession::HandleLootOpcode                },
    /*0x15E*/ { "CMSG_LOOT_MONEY",                  STATUS_LOGGEDIN, &WorldSession::HandleLootMoneyOpcode           },
    /*0x15F*/ { "CMSG_LOOT_RELEASE",                STATUS_LOGGEDIN, &WorldSession::HandleLootReleaseOpcode         },
    /*0x160*/ { "SMSG_LOOT_RESPONSE",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x161*/ { "SMSG_LOOT_RELEASE_RESPONSE",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x162*/ { "SMSG_LOOT_REMOVED",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x163*/ { "SMSG_LOOT_MONEY_NOTIFY",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x164*/ { "SMSG_LOOT_ITEM_NOTIFY",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x165*/ { "SMSG_LOOT_CLEAR_MONEY",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x166*/ { "SMSG_ITEM_PUSH_RESULT",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x167*/ { "SMSG_DUEL_REQUESTED",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x168*/ { "SMSG_DUEL_OUTOFBOUNDS",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x169*/ { "SMSG_DUEL_INBOUNDS",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x16A*/ { "SMSG_DUEL_COMPLETE",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x16B*/ { "SMSG_DUEL_WINNER",                 STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x16C*/ { "CMSG_DUEL_ACCEPTED",               STATUS_LOGGEDIN, &WorldSession::HandleDuelAcceptedOpcode        },
    /*0x16D*/ { "CMSG_DUEL_CANCELLED",              STATUS_LOGGEDIN, &WorldSession::HandleDuelCancelledOpcode       },
    /*0x16E*/ { "SMSG_MOUNTRESULT",                 STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x16F*/ { "SMSG_DISMOUNTRESULT",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x170*/ { "SMSG_PUREMOUNT_CANCELLED_OBSOLETE",STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x171*/ { "CMSG_MOUNTSPECIAL_ANIM",           STATUS_LOGGEDIN, &WorldSession::HandleMountSpecialAnimOpcode    },
    /*0x172*/ { "SMSG_MOUNTSPECIAL_ANIM",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x173*/ { "SMSG_PET_TAME_FAILURE",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x174*/ { "CMSG_PET_SET_ACTION",              STATUS_LOGGEDIN, &WorldSession::HandlePetSetAction              },
    /*0x175*/ { "CMSG_PET_ACTION",                  STATUS_LOGGEDIN, &WorldSession::HandlePetAction                 },
    /*0x176*/ { "CMSG_PET_ABANDON",                 STATUS_LOGGEDIN, &WorldSession::HandlePetAbandon                },
    /*0x177*/ { "CMSG_PET_RENAME",                  STATUS_LOGGEDIN, &WorldSession::HandlePetRename                 },
    /*0x178*/ { "SMSG_PET_NAME_INVALID",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x179*/ { "SMSG_PET_SPELLS",                  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x17A*/ { "SMSG_PET_MODE",                    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x17B*/ { "CMSG_GOSSIP_HELLO",                STATUS_LOGGEDIN, &WorldSession::HandleGossipHelloOpcode         },
    /*0x17C*/ { "CMSG_GOSSIP_SELECT_OPTION",        STATUS_LOGGEDIN, &WorldSession::HandleGossipSelectOptionOpcode  },
    /*0x17D*/ { "SMSG_GOSSIP_MESSAGE",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x17E*/ { "SMSG_GOSSIP_COMPLETE",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x17F*/ { "CMSG_NPC_TEXT_QUERY",              STATUS_LOGGEDIN, &WorldSession::HandleNpcTextQueryOpcode        },
    /*0x180*/ { "SMSG_NPC_TEXT_UPDATE",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x181*/ { "SMSG_NPC_WONT_TALK",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x182*/ { "CMSG_QUESTGIVER_STATUS_QUERY",     STATUS_LOGGEDIN, &WorldSession::HandleQuestgiverStatusQueryOpcode},
    /*0x183*/ { "SMSG_QUESTGIVER_STATUS",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x184*/ { "CMSG_QUESTGIVER_HELLO",            STATUS_LOGGEDIN, &WorldSession::HandleQuestgiverHelloOpcode     },
    /*0x185*/ { "SMSG_QUESTGIVER_QUEST_LIST",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x186*/ { "CMSG_QUESTGIVER_QUERY_QUEST",      STATUS_LOGGEDIN, &WorldSession::HandleQuestgiverQuestQueryOpcode},
    /*0x187*/ { "CMSG_QUESTGIVER_QUEST_AUTOLAUNCH", STATUS_LOGGEDIN, &WorldSession::HandleQuestAutoLaunch           },
    /*0x188*/ { "SMSG_QUESTGIVER_QUEST_DETAILS",    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x189*/ { "CMSG_QUESTGIVER_ACCEPT_QUEST",     STATUS_LOGGEDIN, &WorldSession::HandleQuestgiverAcceptQuestOpcode},
    /*0x18A*/ { "CMSG_QUESTGIVER_COMPLETE_QUEST",   STATUS_LOGGEDIN, &WorldSession::HandleQuestComplete             },
    /*0x18B*/ { "SMSG_QUESTGIVER_REQUEST_ITEMS",    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x18C*/ { "CMSG_QUESTGIVER_REQUEST_REWARD",   STATUS_LOGGEDIN, &WorldSession::HandleQuestgiverRequestRewardOpcode},
    /*0x18D*/ { "SMSG_QUESTGIVER_OFFER_REWARD",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x18E*/ { "CMSG_QUESTGIVER_CHOOSE_REWARD",    STATUS_LOGGEDIN, &WorldSession::HandleQuestgiverChooseRewardOpcode},
    /*0x18F*/ { "SMSG_QUESTGIVER_QUEST_INVALID",    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x190*/ { "CMSG_QUESTGIVER_CANCEL",           STATUS_LOGGEDIN, &WorldSession::HandleQuestgiverCancel          },
    /*0x191*/ { "SMSG_QUESTGIVER_QUEST_COMPLETE",   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x192*/ { "SMSG_QUESTGIVER_QUEST_FAILED",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x193*/ { "CMSG_QUESTLOG_SWAP_QUEST",         STATUS_LOGGEDIN, &WorldSession::HandleQuestLogSwapQuest         },
    /*0x194*/ { "CMSG_QUESTLOG_REMOVE_QUEST",       STATUS_LOGGEDIN, &WorldSession::HandleQuestLogRemoveQuest       },
    /*0x195*/ { "SMSG_QUESTLOG_FULL",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x196*/ { "SMSG_QUESTUPDATE_FAILED",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x197*/ { "SMSG_QUESTUPDATE_FAILEDTIMER",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x198*/ { "SMSG_QUESTUPDATE_COMPLETE",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x199*/ { "SMSG_QUESTUPDATE_ADD_KILL",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x19A*/ { "SMSG_QUESTUPDATE_ADD_ITEM",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x19B*/ { "CMSG_QUEST_CONFIRM_ACCEPT",        STATUS_LOGGEDIN, &WorldSession::HandleQuestConfirmAccept        },
    /*0x19C*/ { "SMSG_QUEST_CONFIRM_ACCEPT",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x19D*/ { "CMSG_PUSHQUESTTOPARTY",            STATUS_LOGGEDIN, &WorldSession::HandleQuestPushToParty          },
    /*0x19E*/ { "CMSG_LIST_INVENTORY",              STATUS_LOGGEDIN, &WorldSession::HandleListInventoryOpcode       },
    /*0x19F*/ { "SMSG_LIST_INVENTORY",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1A0*/ { "CMSG_SELL_ITEM",                   STATUS_LOGGEDIN, &WorldSession::HandleSellItemOpcode            },
    /*0x1A1*/ { "SMSG_SELL_ITEM",                   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1A2*/ { "CMSG_BUY_ITEM",                    STATUS_LOGGEDIN, &WorldSession::HandleBuyItemOpcode             },
    /*0x1A3*/ { "CMSG_BUY_ITEM_IN_SLOT",            STATUS_LOGGEDIN, &WorldSession::HandleBuyItemInSlotOpcode       },
    /*0x1A4*/ { "SMSG_BUY_ITEM",                    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1A5*/ { "SMSG_BUY_FAILED",                  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1A6*/ { "CMSG_TAXICLEARALLNODES",           STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x1A7*/ { "CMSG_TAXIENABLEALLNODES",          STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x1A8*/ { "CMSG_TAXISHOWNODES",               STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x1A9*/ { "SMSG_SHOWTAXINODES",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1AA*/ { "CMSG_TAXINODE_STATUS_QUERY",       STATUS_LOGGEDIN, &WorldSession::HandleTaxiNodeStatusQueryOpcode },
    /*0x1AB*/ { "SMSG_TAXINODE_STATUS",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1AC*/ { "CMSG_TAXIQUERYAVAILABLENODES",     STATUS_LOGGEDIN, &WorldSession::HandleTaxiQueryAvailableNodesOpcode},
    /*0x1AD*/ { "CMSG_ACTIVATETAXI",                STATUS_LOGGEDIN, &WorldSession::HandleActivateTaxiOpcode        },
    /*0x1AE*/ { "SMSG_ACTIVATETAXIREPLY",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1AF*/ { "SMSG_NEW_TAXI_PATH",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1B0*/ { "CMSG_TRAINER_LIST",                STATUS_LOGGEDIN, &WorldSession::HandleTrainerListOpcode         },
    /*0x1B1*/ { "SMSG_TRAINER_LIST",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1B2*/ { "CMSG_TRAINER_BUY_SPELL",           STATUS_LOGGEDIN, &WorldSession::HandleTrainerBuySpellOpcode     },
    /*0x1B3*/ { "SMSG_TRAINER_BUY_SUCCEEDED",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1B4*/ { "SMSG_TRAINER_BUY_FAILED",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1B5*/ { "CMSG_BINDER_ACTIVATE",             STATUS_LOGGEDIN, &WorldSession::HandleBinderActivateOpcode      },
    /*0x1B6*/ { "SMSG_PLAYERBINDERROR",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1B7*/ { "CMSG_BANKER_ACTIVATE",             STATUS_LOGGEDIN, &WorldSession::HandleBankerActivateOpcode      },
    /*0x1B8*/ { "SMSG_SHOW_BANK",                   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1B9*/ { "CMSG_BUY_BANK_SLOT",               STATUS_LOGGEDIN, &WorldSession::HandleBuyBankSlotOpcode         },
    /*0x1BA*/ { "SMSG_BUY_BANK_SLOT_RESULT",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1BB*/ { "CMSG_PETITION_SHOWLIST",           STATUS_LOGGEDIN, &WorldSession::HandlePetitionShowListOpcode    },
    /*0x1BC*/ { "SMSG_PETITION_SHOWLIST",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1BD*/ { "CMSG_PETITION_BUY",                STATUS_LOGGEDIN, &WorldSession::HandlePetitionBuyOpcode         },
    /*0x1BE*/ { "CMSG_PETITION_SHOW_SIGNATURES",    STATUS_LOGGEDIN, &WorldSession::HandlePetitionShowSignOpcode    },
    /*0x1BF*/ { "SMSG_PETITION_SHOW_SIGNATURES",    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1C0*/ { "CMSG_PETITION_SIGN",               STATUS_LOGGEDIN, &WorldSession::HandlePetitionSignOpcode        },
    /*0x1C1*/ { "SMSG_PETITION_SIGN_RESULTS",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1C2*/ { "MSG_PETITION_DECLINE",             STATUS_LOGGEDIN, &WorldSession::HandlePetitionDeclineOpcode     },
    /*0x1C3*/ { "CMSG_OFFER_PETITION",              STATUS_LOGGEDIN, &WorldSession::HandleOfferPetitionOpcode       },
    /*0x1C4*/ { "CMSG_TURN_IN_PETITION",            STATUS_LOGGEDIN, &WorldSession::HandleTurnInPetitionOpcode      },
    /*0x1C5*/ { "SMSG_TURN_IN_PETITION_RESULTS",    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1C6*/ { "CMSG_PETITION_QUERY",              STATUS_LOGGEDIN, &WorldSession::HandlePetitionQueryOpcode       },
    /*0x1C7*/ { "SMSG_PETITION_QUERY_RESPONSE",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1C8*/ { "SMSG_FISH_NOT_HOOKED",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1C9*/ { "SMSG_FISH_ESCAPED",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1CA*/ { "CMSG_BUG",                         STATUS_LOGGEDIN, &WorldSession::HandleBugOpcode                 },
    /*0x1CB*/ { "SMSG_NOTIFICATION",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1CC*/ { "CMSG_PLAYED_TIME",                 STATUS_LOGGEDIN, &WorldSession::HandlePlayedTime                },
    /*0x1CD*/ { "SMSG_PLAYED_TIME",                 STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1CE*/ { "CMSG_QUERY_TIME",                  STATUS_LOGGEDIN, &WorldSession::HandleQueryTimeOpcode           },
    /*0x1CF*/ { "SMSG_QUERY_TIME_RESPONSE",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1D0*/ { "SMSG_LOG_XPGAIN",                  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1D1*/ { "SMSG_AURACASTLOG",                 STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1D2*/ { "CMSG_RECLAIM_CORPSE",              STATUS_LOGGEDIN, &WorldSession::HandleCorpseReclaimOpcode       },
    /*0x1D3*/ { "CMSG_WRAP_ITEM",                   STATUS_LOGGEDIN, &WorldSession::HandleWrapItemOpcode            },
    /*0x1D4*/ { "SMSG_LEVELUP_INFO",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1D5*/ { "MSG_MINIMAP_PING",                 STATUS_LOGGEDIN, &WorldSession::HandleMinimapPingOpcode         },
    /*0x1D6*/ { "SMSG_RESISTLOG",                   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1D7*/ { "SMSG_ENCHANTMENTLOG",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1D8*/ { "CMSG_SET_SKILL_CHEAT",             STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x1D9*/ { "SMSG_START_MIRROR_TIMER",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1DA*/ { "SMSG_PAUSE_MIRROR_TIMER",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1DB*/ { "SMSG_STOP_MIRROR_TIMER",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1DC*/ { "CMSG_PING",                        STATUS_NEVER,    &WorldSession::Handle_EarlyProccess            },
    /*0x1DD*/ { "SMSG_PONG",                        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1DE*/ { "SMSG_CLEAR_COOLDOWN",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1DF*/ { "SMSG_GAMEOBJECT_PAGETEXT",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1E0*/ { "CMSG_SETSHEATHED",                 STATUS_LOGGEDIN, &WorldSession::HandleSetSheathedOpcode         },
    /*0x1E1*/ { "SMSG_COOLDOWN_CHEAT",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1E2*/ { "SMSG_SPELL_DELAYED",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1E3*/ { "CMSG_PLAYER_MACRO_OBSOLETE",       STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x1E4*/ { "SMSG_PLAYER_MACRO_OBSOLETE",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1E5*/ { "CMSG_GHOST",                       STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x1E6*/ { "CMSG_GM_INVIS",                    STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x1E7*/ { "SMSG_INVALID_PROMOTION_CODE",      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1E8*/ { "MSG_GM_BIND_OTHER",                STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x1E9*/ { "MSG_GM_SUMMON",                    STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x1EA*/ { "SMSG_ITEM_TIME_UPDATE",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1EB*/ { "SMSG_ITEM_ENCHANT_TIME_UPDATE",    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1EC*/ { "SMSG_AUTH_CHALLENGE",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1ED*/ { "CMSG_AUTH_SESSION",                STATUS_NEVER,    &WorldSession::Handle_EarlyProccess            },
    /*0x1EE*/ { "SMSG_AUTH_RESPONSE",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1EF*/ { "MSG_GM_SHOWLABEL",                 STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x1F0*/ { "CMSG_PET_CAST_SPELL",              STATUS_LOGGEDIN, &WorldSession::HandleAddDynamicTargetObsoleteOpcode},
    /*0x1F1*/ { "MSG_SAVE_GUILD_EMBLEM",            STATUS_LOGGEDIN, &WorldSession::HandleGuildSaveEmblemOpcode     },
    /*0x1F2*/ { "MSG_TABARDVENDOR_ACTIVATE",        STATUS_LOGGEDIN, &WorldSession::HandleTabardVendorActivateOpcode},
    /*0x1F3*/ { "SMSG_PLAY_SPELL_VISUAL",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1F4*/ { "CMSG_ZONEUPDATE",                  STATUS_LOGGEDIN, &WorldSession::HandleZoneUpdateOpcode          },
    /*0x1F5*/ { "SMSG_PARTYKILLLOG",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1F6*/ { "SMSG_COMPRESSED_UPDATE_OBJECT",    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1F7*/ { "SMSG_PLAY_SPELL_IMPACT",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1F8*/ { "SMSG_EXPLORATION_EXPERIENCE",      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1F9*/ { "CMSG_GM_SET_SECURITY_GROUP",       STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x1FA*/ { "CMSG_GM_NUKE",                     STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x1FB*/ { "MSG_RANDOM_ROLL",                  STATUS_LOGGEDIN, &WorldSession::HandleRandomRollOpcode          },
    /*0x1FC*/ { "SMSG_ENVIRONMENTALDAMAGELOG",      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1FD*/ { "CMSG_RWHOIS_OBSOLETE",             STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x1FE*/ { "SMSG_RWHOIS",                      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x1FF*/ { "MSG_LOOKING_FOR_GROUP",            STATUS_LOGGEDIN, &WorldSession::HandleLookingForGroup           },
    /*0x200*/ { "CMSG_SET_LOOKING_FOR_GROUP",       STATUS_LOGGEDIN, &WorldSession::HandleSetLfgOpcode              },
    /*0x201*/ { "CMSG_UNLEARN_SPELL",               STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x202*/ { "CMSG_UNLEARN_SKILL",               STATUS_LOGGEDIN, &WorldSession::HandleUnlearnSkillOpcode        },
    /*0x203*/ { "SMSG_REMOVED_SPELL",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x204*/ { "CMSG_DECHARGE",                    STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x205*/ { "CMSG_GMTICKET_CREATE",             STATUS_LOGGEDIN, &WorldSession::HandleGMTicketCreateOpcode      },
    /*0x206*/ { "SMSG_GMTICKET_CREATE",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x207*/ { "CMSG_GMTICKET_UPDATETEXT",         STATUS_LOGGEDIN, &WorldSession::HandleGMTicketUpdateTextOpcode  },
    /*0x208*/ { "SMSG_GMTICKET_UPDATETEXT",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x209*/ { "SMSG_ACCOUNT_DATA_TIMES",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x20A*/ { "CMSG_REQUEST_ACCOUNT_DATA",        STATUS_LOGGEDIN, &WorldSession::HandleRequestAccountData        },
    /*0x20B*/ { "CMSG_UPDATE_ACCOUNT_DATA",         STATUS_LOGGEDIN, &WorldSession::HandleUpdateAccountData         },
    /*0x20C*/ { "SMSG_UPDATE_ACCOUNT_DATA",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x20D*/ { "SMSG_CLEAR_FAR_SIGHT_IMMEDIATE",   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x20E*/ { "SMSG_POWERGAINLOG_OBSOLETE",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x20F*/ { "CMSG_GM_TEACH",                    STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x210*/ { "CMSG_GM_CREATE_ITEM_TARGET",       STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x211*/ { "CMSG_GMTICKET_GETTICKET",          STATUS_LOGGEDIN, &WorldSession::HandleGMTicketGetTicketOpcode   },
    /*0x212*/ { "SMSG_GMTICKET_GETTICKET",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x213*/ { "CMSG_UNLEARN_TALENTS",             STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x214*/ { "SMSG_GAMEOBJECT_SPAWN_ANIM_OBSOLETE",STATUS_NEVER,  &WorldSession::Handle_ServerSide               },
    /*0x215*/ { "SMSG_GAMEOBJECT_DESPAWN_ANIM",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x216*/ { "MSG_CORPSE_QUERY",                 STATUS_LOGGEDIN, &WorldSession::HandleCorpseQueryOpcode         },
    /*0x217*/ { "CMSG_GMTICKET_DELETETICKET",       STATUS_LOGGEDIN, &WorldSession::HandleGMTicketDeleteOpcode      },
    /*0x218*/ { "SMSG_GMTICKET_DELETETICKET",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x219*/ { "SMSG_CHAT_WRONG_FACTION",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x21A*/ { "CMSG_GMTICKET_SYSTEMSTATUS",       STATUS_LOGGEDIN, &WorldSession::HandleGMTicketSystemStatusOpcode},
    /*0x21B*/ { "SMSG_GMTICKET_SYSTEMSTATUS",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x21C*/ { "CMSG_SPIRIT_HEALER_ACTIVATE",      STATUS_LOGGEDIN, &WorldSession::HandleSpiritHealerActivateOpcode},
    /*0x21D*/ { "CMSG_SET_STAT_CHEAT",              STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x21E*/ { "SMSG_SET_REST_START",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x21F*/ { "CMSG_SKILL_BUY_STEP",              STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x220*/ { "CMSG_SKILL_BUY_RANK",              STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x221*/ { "CMSG_XP_CHEAT",                    STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x222*/ { "SMSG_SPIRIT_HEALER_CONFIRM",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x223*/ { "CMSG_CHARACTER_POINT_CHEAT",       STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x224*/ { "SMSG_GOSSIP_POI",                  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x225*/ { "CMSG_CHAT_IGNORED",                STATUS_LOGGEDIN, &WorldSession::HandleChatIgnoredOpcode         },
    /*0x226*/ { "CMSG_GM_VISION",                   STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x227*/ { "CMSG_SERVER_COMMAND",              STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x228*/ { "CMSG_GM_SILENCE",                  STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x229*/ { "CMSG_GM_REVEALTO",                 STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x22A*/ { "CMSG_GM_RESURRECT",                STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x22B*/ { "CMSG_GM_SUMMONMOB",                STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x22C*/ { "CMSG_GM_MOVECORPSE",               STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x22D*/ { "CMSG_GM_FREEZE",                   STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x22E*/ { "CMSG_GM_UBERINVIS",                STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x22F*/ { "CMSG_GM_REQUEST_PLAYER_INFO",      STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x230*/ { "SMSG_GM_PLAYER_INFO",              STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x231*/ { "CMSG_GUILD_RANK",                  STATUS_LOGGEDIN, &WorldSession::HandleGuildRankOpcode           },
    /*0x232*/ { "CMSG_GUILD_ADD_RANK",              STATUS_LOGGEDIN, &WorldSession::HandleGuildAddRankOpcode        },
    /*0x233*/ { "CMSG_GUILD_DEL_RANK",              STATUS_LOGGEDIN, &WorldSession::HandleGuildDelRankOpcode        },
    /*0x234*/ { "CMSG_GUILD_SET_PUBLIC_NOTE",       STATUS_LOGGEDIN, &WorldSession::HandleGuildSetPublicNoteOpcode  },
    /*0x235*/ { "CMSG_GUILD_SET_OFFICER_NOTE",      STATUS_LOGGEDIN, &WorldSession::HandleGuildSetOfficerNoteOpcode },
    /*0x236*/ { "SMSG_LOGIN_VERIFY_WORLD",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x237*/ { "CMSG_CLEAR_EXPLORATION",           STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x238*/ { "CMSG_SEND_MAIL",                   STATUS_LOGGEDIN, &WorldSession::HandleSendMail                  },
    /*0x239*/ { "SMSG_SEND_MAIL_RESULT",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x23A*/ { "CMSG_GET_MAIL_LIST",               STATUS_LOGGEDIN, &WorldSession::HandleGetMail                   },
    /*0x23B*/ { "SMSG_MAIL_LIST_RESULT",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x23C*/ { "CMSG_BATTLEFIELD_LIST",            STATUS_LOGGEDIN, &WorldSession::HandleBattleGroundListOpcode    },
    /*0x23D*/ { "SMSG_BATTLEFIELD_LIST",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x23E*/ { "CMSG_BATTLEFIELD_JOIN",            STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x23F*/ { "SMSG_BATTLEFIELD_WIN_OBSOLETE",    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x240*/ { "SMSG_BATTLEFIELD_LOSE_OBSOLETE",   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x241*/ { "CMSG_TAXICLEARNODE",               STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x242*/ { "CMSG_TAXIENABLENODE",              STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x243*/ { "CMSG_ITEM_TEXT_QUERY",             STATUS_LOGGEDIN, &WorldSession::HandleItemTextQuery             },
    /*0x244*/ { "SMSG_ITEM_TEXT_QUERY_RESPONSE",    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x245*/ { "CMSG_MAIL_TAKE_MONEY",             STATUS_LOGGEDIN, &WorldSession::HandleTakeMoney                 },
    /*0x246*/ { "CMSG_MAIL_TAKE_ITEM",              STATUS_LOGGEDIN, &WorldSession::HandleTakeItem                  },
    /*0x247*/ { "CMSG_MAIL_MARK_AS_READ",           STATUS_LOGGEDIN, &WorldSession::HandleMarkAsRead                },
    /*0x248*/ { "CMSG_MAIL_RETURN_TO_SENDER",       STATUS_LOGGEDIN, &WorldSession::HandleReturnToSender            },
    /*0x249*/ { "CMSG_MAIL_DELETE",                 STATUS_LOGGEDIN, &WorldSession::HandleMailDelete                },
    /*0x24A*/ { "CMSG_MAIL_CREATE_TEXT_ITEM",       STATUS_LOGGEDIN, &WorldSession::HandleMailCreateTextItem        },
    /*0x24B*/ { "SMSG_SPELLLOGMISS",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x24C*/ { "SMSG_SPELLLOGEXECUTE",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x24D*/ { "SMSG_DEBUGAURAPROC",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x24E*/ { "SMSG_PERIODICAURALOG",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x24F*/ { "SMSG_SPELLDAMAGESHIELD",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x250*/ { "SMSG_SPELLNONMELEEDAMAGELOG",      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x251*/ { "CMSG_LEARN_TALENT",                STATUS_LOGGEDIN, &WorldSession::HandleLearnTalentOpcode         },
    /*0x252*/ { "SMSG_RESURRECT_FAILED",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x253*/ { "CMSG_TOGGLE_PVP",                  STATUS_LOGGEDIN, &WorldSession::HandleTogglePvP                 },
    /*0x254*/ { "SMSG_ZONE_UNDER_ATTACK",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x255*/ { "MSG_AUCTION_HELLO",                STATUS_LOGGEDIN, &WorldSession::HandleAuctionHelloOpcode        },
    /*0x256*/ { "CMSG_AUCTION_SELL_ITEM",           STATUS_LOGGEDIN, &WorldSession::HandleAuctionSellItem           },
    /*0x257*/ { "CMSG_AUCTION_REMOVE_ITEM",         STATUS_LOGGEDIN, &WorldSession::HandleAuctionRemoveItem         },
    /*0x258*/ { "CMSG_AUCTION_LIST_ITEMS",          STATUS_LOGGEDIN, &WorldSession::HandleAuctionListItems          },
    /*0x259*/ { "CMSG_AUCTION_LIST_OWNER_ITEMS",    STATUS_LOGGEDIN, &WorldSession::HandleAuctionListOwnerItems     },
    /*0x25A*/ { "CMSG_AUCTION_PLACE_BID",           STATUS_LOGGEDIN, &WorldSession::HandleAuctionPlaceBid           },
    /*0x25B*/ { "SMSG_AUCTION_COMMAND_RESULT",      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x25C*/ { "SMSG_AUCTION_LIST_RESULT",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x25D*/ { "SMSG_AUCTION_OWNER_LIST_RESULT",   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x25E*/ { "SMSG_AUCTION_BIDDER_NOTIFICATION", STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x25F*/ { "SMSG_AUCTION_OWNER_NOTIFICATION",  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x260*/ { "SMSG_PROCRESIST",                  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x261*/ { "SMSG_STANDSTATE_CHANGE_FAILURE_OBSOLETE",STATUS_NEVER,&WorldSession::Handle_ServerSide             },
    /*0x262*/ { "SMSG_DISPEL_FAILED",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x263*/ { "SMSG_SPELLORDAMAGE_IMMUNE",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x264*/ { "CMSG_AUCTION_LIST_BIDDER_ITEMS",   STATUS_LOGGEDIN, &WorldSession::HandleAuctionListBidderItems    },
    /*0x265*/ { "SMSG_AUCTION_BIDDER_LIST_RESULT",  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x266*/ { "SMSG_SET_FLAT_SPELL_MODIFIER",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x267*/ { "SMSG_SET_PCT_SPELL_MODIFIER",      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x268*/ { "CMSG_SET_AMMO",                    STATUS_LOGGEDIN, &WorldSession::HandleSetAmmoOpcode             },
    /*0x269*/ { "SMSG_CORPSE_RECLAIM_DELAY",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x26A*/ { "CMSG_SET_ACTIVE_MOVER",            STATUS_LOGGEDIN, &WorldSession::HandleSetActiveMoverOpcode      },
    /*0x26B*/ { "CMSG_PET_CANCEL_AURA",             STATUS_LOGGEDIN, &WorldSession::HandlePetCancelAuraOpcode       },
    /*0x26C*/ { "CMSG_PLAYER_AI_CHEAT",             STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x26D*/ { "CMSG_CANCEL_AUTO_REPEAT_SPELL",    STATUS_LOGGEDIN, &WorldSession::HandleCancelAutoRepeatSpellOpcode},
    /*0x26E*/ { "MSG_GM_ACCOUNT_ONLINE",            STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x26F*/ { "MSG_LIST_STABLED_PETS",            STATUS_LOGGEDIN, &WorldSession::HandleListStabledPetsOpcode     },
    /*0x270*/ { "CMSG_STABLE_PET",                  STATUS_LOGGEDIN, &WorldSession::HandleStablePet                 },
    /*0x271*/ { "CMSG_UNSTABLE_PET",                STATUS_LOGGEDIN, &WorldSession::HandleUnstablePet               },
    /*0x272*/ { "CMSG_BUY_STABLE_SLOT",             STATUS_LOGGEDIN, &WorldSession::HandleBuyStableSlot             },
    /*0x273*/ { "SMSG_STABLE_RESULT",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x274*/ { "CMSG_STABLE_REVIVE_PET",           STATUS_LOGGEDIN, &WorldSession::HandleStableRevivePet           },
    /*0x275*/ { "CMSG_STABLE_SWAP_PET",             STATUS_LOGGEDIN, &WorldSession::HandleStableSwapPet             },
    /*0x276*/ { "MSG_QUEST_PUSH_RESULT",            STATUS_LOGGEDIN, &WorldSession::HandleQuestPushResult           },
    /*0x277*/ { "SMSG_PLAY_MUSIC",                  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x278*/ { "SMSG_PLAY_OBJECT_SOUND",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x279*/ { "CMSG_REQUEST_PET_INFO",            STATUS_LOGGEDIN, &WorldSession::HandleRequestPetInfoOpcode      },
    /*0x27A*/ { "CMSG_FAR_SIGHT",                   STATUS_LOGGEDIN, &WorldSession::HandleFarSightOpcode            },
    /*0x27B*/ { "SMSG_SPELLDISPELLOG",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x27C*/ { "SMSG_DAMAGE_CALC_LOG",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x27D*/ { "CMSG_ENABLE_DAMAGE_LOG",           STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x27E*/ { "CMSG_GROUP_CHANGE_SUB_GROUP",      STATUS_LOGGEDIN, &WorldSession::HandleGroupChangeSubGroupOpcode },
    /*0x27F*/ { "CMSG_REQUEST_PARTY_MEMBER_STATS",  STATUS_LOGGEDIN, &WorldSession::HandleRequestPartyMemberStatsOpcode},
    /*0x280*/ { "CMSG_GROUP_SWAP_SUB_GROUP",        STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x281*/ { "CMSG_RESET_FACTION_CHEAT",         STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x282*/ { "CMSG_AUTOSTORE_BANK_ITEM",         STATUS_LOGGEDIN, &WorldSession::HandleAutoStoreBankItemOpcode   },
    /*0x283*/ { "CMSG_AUTOBANK_ITEM",               STATUS_LOGGEDIN, &WorldSession::HandleAutoBankItemOpcode        },
    /*0x284*/ { "MSG_QUERY_NEXT_MAIL_TIME",         STATUS_LOGGEDIN, &WorldSession::HandleMsgQueryNextMailtime      },
    /*0x285*/ { "SMSG_RECEIVED_MAIL",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x286*/ { "SMSG_RAID_GROUP_ONLY",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x287*/ { "CMSG_SET_DURABILITY_CHEAT",        STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x288*/ { "CMSG_SET_PVP_RANK_CHEAT",          STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x289*/ { "CMSG_ADD_PVP_MEDAL_CHEAT",         STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x28A*/ { "CMSG_DEL_PVP_MEDAL_CHEAT",         STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x28B*/ { "CMSG_SET_PVP_TITLE",               STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x28C*/ { "SMSG_PVP_CREDIT",                  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x28D*/ { "SMSG_AUCTION_REMOVED_NOTIFICATION",STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x28E*/ { "CMSG_GROUP_RAID_CONVERT",          STATUS_LOGGEDIN, &WorldSession::HandleRaidConvertOpcode         },
    /*0x28F*/ { "CMSG_GROUP_ASSISTANT_LEADER",      STATUS_LOGGEDIN, &WorldSession::HandleGroupAssistantOpcode      },
    /*0x290*/ { "CMSG_BUYBACK_ITEM",                STATUS_LOGGEDIN, &WorldSession::HandleBuybackItem               },
    /*0x291*/ { "SMSG_SERVER_MESSAGE",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x292*/ { "CMSG_MEETINGSTONE_JOIN",           STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x293*/ { "CMSG_MEETINGSTONE_LEAVE",          STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x294*/ { "CMSG_MEETINGSTONE_CHEAT",          STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x295*/ { "SMSG_MEETINGSTONE_SETQUEUE",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x296*/ { "CMSG_MEETINGSTONE_INFO",           STATUS_LOGGEDIN, &WorldSession::HandleMeetingStoneInfo          },
    /*0x297*/ { "SMSG_MEETINGSTONE_COMPLETE",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x298*/ { "SMSG_MEETINGSTONE_IN_PROGRESS",    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x299*/ { "SMSG_MEETINGSTONE_MEMBER_ADDED",   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x29A*/ { "CMSG_GMTICKETSYSTEM_TOGGLE",       STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x29B*/ { "CMSG_CANCEL_GROWTH_AURA",          STATUS_LOGGEDIN, &WorldSession::HandleCancelGrowthAuraOpcode    },
    /*0x29C*/ { "SMSG_CANCEL_AUTO_REPEAT",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x29D*/ { "SMSG_STANDSTATE_UPDATE",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x29E*/ { "SMSG_LOOT_ALL_PASSED",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x29F*/ { "SMSG_LOOT_ROLL_WON",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2A0*/ { "CMSG_LOOT_ROLL",                   STATUS_LOGGEDIN, &WorldSession::HandleLootRoll                  },
    /*0x2A1*/ { "SMSG_LOOT_START_ROLL",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2A2*/ { "SMSG_LOOT_ROLL",                   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2A3*/ { "CMSG_LOOT_MASTER_GIVE",            STATUS_LOGGEDIN, &WorldSession::HandleLootMasterGiveOpcode      },
    /*0x2A4*/ { "SMSG_LOOT_MASTER_LIST",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2A5*/ { "SMSG_SET_FORCED_REACTIONS",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2A6*/ { "SMSG_SPELL_FAILED_OTHER",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2A7*/ { "SMSG_GAMEOBJECT_RESET_STATE",      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2A8*/ { "CMSG_REPAIR_ITEM",                 STATUS_LOGGEDIN, &WorldSession::HandleRepairItemOpcode          },
    /*0x2A9*/ { "SMSG_CHAT_PLAYER_NOT_FOUND",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2AA*/ { "MSG_TALENT_WIPE_CONFIRM",          STATUS_LOGGEDIN, &WorldSession::HandleTalentWipeOpcode          },
    /*0x2AB*/ { "SMSG_SUMMON_REQUEST",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2AC*/ { "CMSG_SUMMON_RESPONSE",             STATUS_LOGGEDIN, &WorldSession::HandleSummonResponseOpcode      },
    /*0x2AD*/ { "MSG_MOVE_TOGGLE_GRAVITY_CHEAT",    STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x2AE*/ { "SMSG_MONSTER_MOVE_TRANSPORT",      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2AF*/ { "SMSG_PET_BROKEN",                  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2B0*/ { "MSG_MOVE_FEATHER_FALL",            STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x2B1*/ { "MSG_MOVE_WATER_WALK",              STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x2B2*/ { "CMSG_SERVER_BROADCAST",            STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x2B3*/ { "CMSG_SELF_RES",                    STATUS_LOGGEDIN, &WorldSession::HandleSelfResOpcode             },
    /*0x2B4*/ { "SMSG_FEIGN_DEATH_RESISTED",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2B5*/ { "CMSG_RUN_SCRIPT",                  STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x2B6*/ { "SMSG_SCRIPT_MESSAGE",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2B7*/ { "SMSG_DUEL_COUNTDOWN",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2B8*/ { "SMSG_AREA_TRIGGER_MESSAGE",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2B9*/ { "CMSG_TOGGLE_HELM",                 STATUS_LOGGEDIN, &WorldSession::HandleToggleHelmOpcode          },
    /*0x2BA*/ { "CMSG_TOGGLE_CLOAK",                STATUS_LOGGEDIN, &WorldSession::HandleToggleCloakOpcode         },
    /*0x2BB*/ { "SMSG_MEETINGSTONE_JOINFAILED",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2BC*/ { "SMSG_PLAYER_SKINNED",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2BD*/ { "SMSG_DURABILITY_DAMAGE_DEATH",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2BE*/ { "CMSG_SET_EXPLORATION",             STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x2BF*/ { "CMSG_SET_ACTIONBAR_TOGGLES",       STATUS_AUTHED,   &WorldSession::HandleSetActionBar              },
    /*0x2C0*/ { "UMSG_DELETE_GUILD_CHARTER",        STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x2C1*/ { "MSG_PETITION_RENAME",              STATUS_LOGGEDIN, &WorldSession::HandlePetitionRenameOpcode      },
    /*0x2C2*/ { "SMSG_INIT_WORLD_STATES",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2C3*/ { "SMSG_UPDATE_WORLD_STATE",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2C4*/ { "CMSG_ITEM_NAME_QUERY",             STATUS_LOGGEDIN, &WorldSession::HandleItemNameQueryOpcode       },
    /*0x2C5*/ { "SMSG_ITEM_NAME_QUERY_RESPONSE",    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2C6*/ { "SMSG_PET_ACTION_FEEDBACK",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2C7*/ { "CMSG_CHAR_RENAME",                 STATUS_AUTHED,   &WorldSession::HandleChangePlayerNameOpcode    },
    /*0x2C8*/ { "SMSG_CHAR_RENAME",                 STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2C9*/ { "CMSG_MOVE_SPLINE_DONE",            STATUS_LOGGEDIN, &WorldSession::HandleTaxiNextDestinationOpcode },
    /*0x2CA*/ { "CMSG_MOVE_FALL_RESET",             STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x2CB*/ { "SMSG_INSTANCE_SAVE_CREATED",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2CC*/ { "SMSG_RAID_INSTANCE_INFO",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2CD*/ { "CMSG_REQUEST_RAID_INFO",           STATUS_LOGGEDIN, &WorldSession::HandleRequestRaidInfoOpcode     },
    /*0x2CE*/ { "CMSG_MOVE_TIME_SKIPPED",           STATUS_LOGGEDIN, &WorldSession::HandleMoveTimeSkippedOpcode     },
    /*0x2CF*/ { "CMSG_MOVE_FEATHER_FALL_ACK",       STATUS_LOGGEDIN, &WorldSession::HandleFeatherFallAck            },
    /*0x2D0*/ { "CMSG_MOVE_WATER_WALK_ACK",         STATUS_LOGGEDIN, &WorldSession::HandleMoveWaterWalkAck          },
    /*0x2D1*/ { "CMSG_MOVE_NOT_ACTIVE_MOVER",       STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x2D2*/ { "SMSG_PLAY_SOUND",                  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2D3*/ { "CMSG_BATTLEFIELD_STATUS",          STATUS_LOGGEDIN, &WorldSession::HandleBattlefieldStatusOpcode   },
    /*0x2D4*/ { "SMSG_BATTLEFIELD_STATUS",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2D5*/ { "CMSG_BATTLEFIELD_PORT",            STATUS_LOGGEDIN, &WorldSession::HandleBattleGroundPlayerPortOpcode},
    /*0x2D6*/ { "MSG_INSPECT_HONOR_STATS",          STATUS_LOGGEDIN, &WorldSession::HandleInspectHonorStatsOpcode   },
    /*0x2D7*/ { "CMSG_BATTLEMASTER_HELLO",          STATUS_LOGGEDIN, &WorldSession::HandleBattleGroundHelloOpcode   },
    /*0x2D8*/ { "CMSG_MOVE_START_SWIM_CHEAT",       STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x2D9*/ { "CMSG_MOVE_STOP_SWIM_CHEAT",        STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x2DA*/ { "SMSG_FORCE_WALK_SPEED_CHANGE",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2DB*/ { "CMSG_FORCE_WALK_SPEED_CHANGE_ACK", STATUS_LOGGEDIN, &WorldSession::HandleForceSpeedChangeAck       },
    /*0x2DC*/ { "SMSG_FORCE_SWIM_BACK_SPEED_CHANGE",STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2DD*/ { "CMSG_FORCE_SWIM_BACK_SPEED_CHANGE_ACK",STATUS_LOGGEDIN,&WorldSession::HandleForceSpeedChangeAck    },
    /*0x2DE*/ { "SMSG_FORCE_TURN_RATE_CHANGE",      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2DF*/ { "CMSG_FORCE_TURN_RATE_CHANGE_ACK",  STATUS_LOGGEDIN, &WorldSession::HandleForceSpeedChangeAck       },
    /*0x2E0*/ { "MSG_PVP_LOG_DATA",                 STATUS_LOGGEDIN, &WorldSession::HandleBattleGroundPVPlogdataOpcode},
    /*0x2E1*/ { "CMSG_LEAVE_BATTLEFIELD",           STATUS_LOGGEDIN, &WorldSession::HandleBattleGroundLeaveOpcode   },
    /*0x2E2*/ { "CMSG_AREA_SPIRIT_HEALER_QUERY",    STATUS_LOGGEDIN, &WorldSession::HandleAreaSpiritHealerQueryOpcode},
    /*0x2E3*/ { "CMSG_AREA_SPIRIT_HEALER_QUEUE",    STATUS_LOGGEDIN, &WorldSession::HandleAreaSpiritHealerQueueOpcode},
    /*0x2E4*/ { "SMSG_AREA_SPIRIT_HEALER_TIME",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2E5*/ { "CMSG_GM_UNTEACH",                  STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x2E6*/ { "SMSG_WARDEN_DATA",                 STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2E7*/ { "CMSG_WARDEN_DATA",                 STATUS_LOGGEDIN, &WorldSession::HandleWardenDataOpcode          },
    /*0x2E8*/ { "SMSG_GROUP_JOINED_BATTLEGROUND",   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2E9*/ { "MSG_BATTLEGROUND_PLAYER_POSITIONS",STATUS_LOGGEDIN, &WorldSession::HandleBattleGroundPlayerPositionsOpcode},
    /*0x2EA*/ { "CMSG_PET_STOP_ATTACK",             STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x2EB*/ { "SMSG_BINDER_CONFIRM",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2EC*/ { "SMSG_BATTLEGROUND_PLAYER_JOINED",  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2ED*/ { "SMSG_BATTLEGROUND_PLAYER_LEFT",    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2EE*/ { "CMSG_BATTLEMASTER_JOIN",           STATUS_LOGGEDIN, &WorldSession::HandleBattleGroundJoinOpcode    },
    /*0x2EF*/ { "SMSG_ADDON_INFO",                  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2F0*/ { "CMSG_PET_UNLEARN",                 STATUS_LOGGEDIN, &WorldSession::HandlePetUnlearnOpcode          },
    /*0x2F1*/ { "SMSG_PET_UNLEARN_CONFIRM",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2F2*/ { "SMSG_PARTY_MEMBER_STATS_FULL",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2F3*/ { "CMSG_PET_SPELL_AUTOCAST",          STATUS_LOGGEDIN, &WorldSession::HandlePetSpellAutocastOpcode    },
    /*0x2F4*/ { "SMSG_WEATHER",                     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2F5*/ { "SMSG_PLAY_TIME_WARNING",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2F6*/ { "SMSG_MINIGAME_SETUP",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2F7*/ { "SMSG_MINIGAME_STATE",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2F8*/ { "CMSG_MINIGAME_MOVE",               STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x2F9*/ { "SMSG_MINIGAME_MOVE_FAILED",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2FA*/ { "SMSG_RAID_INSTANCE_MESSAGE",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2FB*/ { "SMSG_COMPRESSED_MOVES",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2FC*/ { "CMSG_GUILD_INFO_TEXT",             STATUS_LOGGEDIN, &WorldSession::HandleGuildChangeInfoOpcode     },
    /*0x2FD*/ { "SMSG_CHAT_RESTRICTED",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2FE*/ { "SMSG_SPLINE_SET_RUN_SPEED",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x2FF*/ { "SMSG_SPLINE_SET_RUN_BACK_SPEED",   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x300*/ { "SMSG_SPLINE_SET_SWIM_SPEED",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x301*/ { "SMSG_SPLINE_SET_WALK_SPEED",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x302*/ { "SMSG_SPLINE_SET_SWIM_BACK_SPEED",  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x303*/ { "SMSG_SPLINE_SET_TURN_RATE",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x304*/ { "SMSG_SPLINE_MOVE_UNROOT",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x305*/ { "SMSG_SPLINE_MOVE_FEATHER_FALL",    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x306*/ { "SMSG_SPLINE_MOVE_NORMAL_FALL",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x307*/ { "SMSG_SPLINE_MOVE_SET_HOVER",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x308*/ { "SMSG_SPLINE_MOVE_UNSET_HOVER",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x309*/ { "SMSG_SPLINE_MOVE_WATER_WALK",      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x30A*/ { "SMSG_SPLINE_MOVE_LAND_WALK",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x30B*/ { "SMSG_SPLINE_MOVE_START_SWIM",      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x30C*/ { "SMSG_SPLINE_MOVE_STOP_SWIM",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x30D*/ { "SMSG_SPLINE_MOVE_SET_RUN_MODE",    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x30E*/ { "SMSG_SPLINE_MOVE_SET_WALK_MODE",   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x30F*/ { "CMSG_GM_NUKE_ACCOUNT",             STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x310*/ { "MSG_GM_DESTROY_CORPSE",            STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x311*/ { "CMSG_GM_DESTROY_ONLINE_CORPSE",    STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x312*/ { "CMSG_ACTIVATETAXIEXPRESS",         STATUS_LOGGEDIN, &WorldSession::HandleActivateTaxiFarOpcode     },
    /*0x313*/ { "SMSG_SET_FACTION_ATWAR",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x314*/ { "SMSG_GAMETIMEBIAS_SET",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x315*/ { "CMSG_DEBUG_ACTIONS_START",         STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x316*/ { "CMSG_DEBUG_ACTIONS_STOP",          STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x317*/ { "CMSG_SET_FACTION_INACTIVE",        STATUS_LOGGEDIN, &WorldSession::HandleSetWatchedFactionInactiveOpcode},
    /*0x318*/ { "CMSG_SET_WATCHED_FACTION",         STATUS_LOGGEDIN, &WorldSession::HandleSetWatchedFactionIndexOpcode},
    /*0x319*/ { "MSG_MOVE_TIME_SKIPPED",            STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x31A*/ { "SMSG_SPLINE_MOVE_ROOT",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x31B*/ { "CMSG_SET_EXPLORATION_ALL",         STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x31C*/ { "SMSG_INVALIDATE_PLAYER",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x31D*/ { "CMSG_RESET_INSTANCES",             STATUS_LOGGEDIN, &WorldSession::HandleResetInstancesOpcode      },
    /*0x31E*/ { "SMSG_INSTANCE_RESET",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x31F*/ { "SMSG_INSTANCE_RESET_FAILED",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x320*/ { "SMSG_UPDATE_LAST_INSTANCE",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x321*/ { "MSG_RAID_TARGET_UPDATE",           STATUS_LOGGEDIN, &WorldSession::HandleRaidIconTargetOpcode      },
    /*0x322*/ { "MSG_RAID_READY_CHECK",             STATUS_LOGGEDIN, &WorldSession::HandleRaidReadyCheckOpcode      },
    /*0x323*/ { "CMSG_LUA_USAGE",                   STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x324*/ { "SMSG_PET_ACTION_SOUND",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x325*/ { "SMSG_PET_DISMISS_SOUND",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x326*/ { "SMSG_GHOSTEE_GONE",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x327*/ { "CMSG_GM_UPDATE_TICKET_STATUS",     STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x328*/ { "SMSG_GM_TICKET_STATUS_UPDATE",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x329*/ { "MSG_SET_DUNGEON_DIFFICULTY",       STATUS_LOGGEDIN, &WorldSession::HandleDungeonDifficultyOpcode   },
    /*0x32A*/ { "CMSG_GMSURVEY_SUBMIT",             STATUS_LOGGEDIN, &WorldSession::HandleGMSurveySubmit            },
    /*0x32B*/ { "SMSG_UPDATE_INSTANCE_OWNERSHIP",   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x32C*/ { "CMSG_IGNORE_KNOCKBACK_CHEAT",      STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x32D*/ { "SMSG_CHAT_PLAYER_AMBIGUOUS",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x32E*/ { "MSG_DELAY_GHOST_TELEPORT",         STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x32F*/ { "SMSG_SPELLINSTAKILLLOG",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x330*/ { "SMSG_SPELL_UPDATE_CHAIN_TARGETS",  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x331*/ { "CMSG_CHAT_FILTERED",               STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x332*/ { "SMSG_EXPECTED_SPAM_RECORDS",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x333*/ { "SMSG_SPELLSTEALLOG",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x334*/ { "CMSG_LOTTERY_QUERY_OBSOLETE",      STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x335*/ { "SMSG_LOTTERY_QUERY_RESULT_OBSOLETE",STATUS_NEVER,   &WorldSession::Handle_ServerSide               },
    /*0x336*/ { "CMSG_BUY_LOTTERY_TICKET_OBSOLETE", STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x337*/ { "SMSG_LOTTERY_RESULT_OBSOLETE",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x338*/ { "SMSG_CHARACTER_PROFILE",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x339*/ { "SMSG_CHARACTER_PROFILE_REALM_CONNECTED",STATUS_NEVER,&WorldSession::Handle_ServerSide              },
    /*0x33A*/ { "SMSG_DEFENSE_MESSAGE",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x33B*/ { "SMSG_INSTANCE_DIFFICULTY",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x33C*/ { "MSG_GM_RESETINSTANCELIMIT",        STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x33D*/ { "SMSG_MOTD",                        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x33E*/ { "SMSG_MOVE_SET_FLIGHT_OBSOLETE",    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x33F*/ { "SMSG_MOVE_UNSET_FLIGHT_OBSOLETE",  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x340*/ { "CMSG_MOVE_FLIGHT_ACK_OBSOLETE",    STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x341*/ { "MSG_MOVE_START_SWIM_CHEAT",        STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x342*/ { "MSG_MOVE_STOP_SWIM_CHEAT",         STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x343*/ { "SMSG_MOVE_SET_CAN_FLY",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x344*/ { "SMSG_MOVE_UNSET_CAN_FLY",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x345*/ { "CMSG_MOVE_SET_CAN_FLY_ACK",        STATUS_LOGGEDIN, &WorldSession::HandleMoveFlyModeChangeAckOpcode},
    /*0x346*/ { "CMSG_MOVE_SET_FLY",                STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x347*/ { "CMSG_SOCKET_GEMS",                 STATUS_LOGGEDIN, &WorldSession::HandleSocketOpcode              },
    /*0x348*/ { "CMSG_ARENA_TEAM_CREATE",           STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x349*/ { "SMSG_ARENA_TEAM_COMMAND_RESULT",   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x34A*/ { "UMSG_UPDATE_ARENA_TEAM_OBSOLETE",  STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x34B*/ { "CMSG_ARENA_TEAM_QUERY",            STATUS_LOGGEDIN, &WorldSession::HandleArenaTeamQueryOpcode      },
    /*0x34C*/ { "SMSG_ARENA_TEAM_QUERY_RESPONSE",   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x34D*/ { "CMSG_ARENA_TEAM_ROSTER",           STATUS_LOGGEDIN, &WorldSession::HandleArenaTeamRosterOpcode     },
    /*0x34E*/ { "SMSG_ARENA_TEAM_ROSTER",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x34F*/ { "CMSG_ARENA_TEAM_INVITE",           STATUS_LOGGEDIN, &WorldSession::HandleArenaTeamAddMemberOpcode  },
    /*0x350*/ { "SMSG_ARENA_TEAM_INVITE",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x351*/ { "CMSG_ARENA_TEAM_ACCEPT",           STATUS_LOGGEDIN, &WorldSession::HandleArenaTeamInviteAcceptOpcode},
    /*0x352*/ { "CMSG_ARENA_TEAM_DECLINE",          STATUS_LOGGEDIN, &WorldSession::HandleArenaTeamInviteDeclineOpcode},
    /*0x353*/ { "CMSG_ARENA_TEAM_LEAVE",            STATUS_LOGGEDIN, &WorldSession::HandleArenaTeamLeaveOpcode      },
    /*0x354*/ { "CMSG_ARENA_TEAM_REMOVE",           STATUS_LOGGEDIN, &WorldSession::HandleArenaTeamRemoveFromTeamOpcode},
    /*0x355*/ { "CMSG_ARENA_TEAM_DISBAND",          STATUS_LOGGEDIN, &WorldSession::HandleArenaTeamDisbandOpcode    },
    /*0x356*/ { "CMSG_ARENA_TEAM_LEADER",           STATUS_LOGGEDIN, &WorldSession::HandleArenaTeamPromoteToCaptainOpcode},
    /*0x357*/ { "SMSG_ARENA_TEAM_EVENT",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x358*/ { "CMSG_BATTLEMASTER_JOIN_ARENA",     STATUS_LOGGEDIN, &WorldSession::HandleBattleGroundArenaJoin     },
    /*0x359*/ { "MSG_MOVE_START_ASCEND",            STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x35A*/ { "MSG_MOVE_STOP_ASCEND",             STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x35B*/ { "SMSG_ARENA_TEAM_STATS",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x35C*/ { "CMSG_LFG_SET_AUTOJOIN",            STATUS_AUTHED,   &WorldSession::HandleLfgAutoJoinOpcode         },
    /*0x35D*/ { "CMSG_LFG_CLEAR_AUTOJOIN",          STATUS_LOGGEDIN, &WorldSession::HandleLfgCancelAutoJoinOpcode   },
    /*0x35E*/ { "CMSG_LFM_SET_AUTOFILL",            STATUS_AUTHED,   &WorldSession::HandleLfmAutoAddMembersOpcode   },
    /*0x35F*/ { "CMSG_LFM_CLEAR_AUTOFILL",          STATUS_LOGGEDIN, &WorldSession::HandleLfmCancelAutoAddmembersOpcode},
    /*0x360*/ { "CMSG_ACCEPT_LFG_MATCH",            STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x361*/ { "CMSG_DECLINE_LFG_MATCH",           STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x362*/ { "CMSG_CANCEL_PENDING_LFG",          STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x363*/ { "CMSG_CLEAR_LOOKING_FOR_GROUP",     STATUS_LOGGEDIN, &WorldSession::HandleLfgClearOpcode            },
    /*0x364*/ { "CMSG_CLEAR_LOOKING_FOR_MORE",      STATUS_LOGGEDIN, &WorldSession::HandleLfmSetNoneOpcode          },
    /*0x365*/ { "CMSG_SET_LOOKING_FOR_MORE",        STATUS_LOGGEDIN, &WorldSession::HandleLfmSetOpcode              },
    /*0x366*/ { "CMSG_SET_LFG_COMMENT",             STATUS_LOGGEDIN, &WorldSession::HandleLfgSetCommentOpcode       },
    /*0x367*/ { "SMSG_LFG_TIMEDOUT",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x368*/ { "SMSG_LFG_OTHER_TIMEDOUT",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x369*/ { "SMSG_LFG_AUTOJOIN_FAILED",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x36A*/ { "SMSG_LFG_AUTOJOIN_FAILED_NO_PLAYER",STATUS_NEVER,   &WorldSession::Handle_ServerSide               },
    /*0x36B*/ { "SMSG_LFG_LEADER_IS_LFM",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x36C*/ { "SMSG_LFG_UPDATE",                  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x36D*/ { "SMSG_LFG_UPDATE_LFM",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x36E*/ { "SMSG_LFG_UPDATE_LFG",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x36F*/ { "SMSG_LFG_UPDATE_QUEUED",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x370*/ { "SMSG_LFG_PENDING_INVITE",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x371*/ { "SMSG_LFG_PENDING_MATCH",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x372*/ { "SMSG_LFG_PENDING_MATCH_DONE",      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x373*/ { "SMSG_TITLE_EARNED",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x374*/ { "CMSG_SET_TITLE",                   STATUS_LOGGEDIN, &WorldSession::HandleChooseTitleOpcode         },
    /*0x375*/ { "CMSG_CANCEL_MOUNT_AURA",           STATUS_LOGGEDIN, &WorldSession::HandleDismountOpcode            },
    /*0x376*/ { "SMSG_ARENA_ERROR",                 STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x377*/ { "MSG_INSPECT_ARENA_TEAMS",          STATUS_LOGGEDIN, &WorldSession::HandleInspectArenaStatsOpcode   },
    /*0x378*/ { "SMSG_DEATH_RELEASE_LOC",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x379*/ { "CMSG_CANCEL_TEMP_ENCHANTMENT",     STATUS_LOGGEDIN, &WorldSession::HandleCancelTempItemEnchantmentOpcode},
    /*0x37A*/ { "SMSG_FORCED_DEATH_UPDATE",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x37B*/ { "CMSG_CHEAT_SET_HONOR_CURRENCY",    STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x37C*/ { "CMSG_CHEAT_SET_ARENA_CURRENCY",    STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x37D*/ { "MSG_MOVE_SET_FLIGHT_SPEED_CHEAT",  STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x37E*/ { "MSG_MOVE_SET_FLIGHT_SPEED",        STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x37F*/ { "MSG_MOVE_SET_FLIGHT_BACK_SPEED_CHEAT",STATUS_NEVER, &WorldSession::Handle_NULL                     },
    /*0x380*/ { "MSG_MOVE_SET_FLIGHT_BACK_SPEED",   STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x381*/ { "SMSG_FORCE_FLIGHT_SPEED_CHANGE",   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x382*/ { "CMSG_FORCE_FLIGHT_SPEED_CHANGE_ACK",STATUS_LOGGEDIN,&WorldSession::HandleForceSpeedChangeAck       },
    /*0x383*/ { "SMSG_FORCE_FLIGHT_BACK_SPEED_CHANGE",STATUS_NEVER,  &WorldSession::Handle_ServerSide               },
    /*0x384*/ { "CMSG_FORCE_FLIGHT_BACK_SPEED_CHANGE_ACK",STATUS_LOGGEDIN,&WorldSession::HandleForceSpeedChangeAck  },
    /*0x385*/ { "SMSG_SPLINE_SET_FLIGHT_SPEED",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x386*/ { "SMSG_SPLINE_SET_FLIGHT_BACK_SPEED",STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x387*/ { "CMSG_MAELSTROM_INVALIDATE_CACHE",  STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x388*/ { "SMSG_FLIGHT_SPLINE_SYNC",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x389*/ { "CMSG_SET_TAXI_BENCHMARK_MODE",     STATUS_AUTHED,   &WorldSession::HandleSetTaxiBenchmarkOpcode    },
    /*0x38A*/ { "SMSG_JOINED_BATTLEGROUND_QUEUE",   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x38B*/ { "SMSG_REALM_SPLIT",                 STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x38C*/ { "CMSG_REALM_SPLIT",                 STATUS_AUTHED,   &WorldSession::HandleRealmStateRequestOpcode   },
    /*0x38D*/ { "CMSG_MOVE_CHNG_TRANSPORT",         STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x38E*/ { "MSG_PARTY_ASSIGNMENT",             STATUS_LOGGEDIN, &WorldSession::HandleGroupPromoteOpcode        },
    /*0x38F*/ { "SMSG_OFFER_PETITION_ERROR",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x390*/ { "SMSG_TIME_SYNC_REQ",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x391*/ { "CMSG_TIME_SYNC_RESP",              STATUS_LOGGEDIN, &WorldSession::HandleAllowMoveAckOpcode        },
    /*0x392*/ { "CMSG_SEND_LOCAL_EVENT",            STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x393*/ { "CMSG_SEND_GENERAL_TRIGGER",        STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x394*/ { "CMSG_SEND_COMBAT_TRIGGER",         STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x395*/ { "CMSG_MAELSTROM_GM_SENT_MAIL",      STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x396*/ { "SMSG_RESET_FAILED_NOTIFY",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x397*/ { "SMSG_REAL_GROUP_UPDATE",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x398*/ { "SMSG_LFG_DISABLED",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x399*/ { "CMSG_ACTIVE_PVP_CHEAT",            STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x39A*/ { "CMSG_CHEAT_DUMP_ITEMS_DEBUG_ONLY", STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x39B*/ { "SMSG_CHEAT_DUMP_ITEMS_DEBUG_ONLY_RESPONSE",STATUS_NEVER,&WorldSession::Handle_ServerSide           },
    /*0x39C*/ { "SMSG_CHEAT_DUMP_ITEMS_DEBUG_ONLY_RESPONSE_WRITE_FILE",STATUS_NEVER,&WorldSession::Handle_ServerSide},
    /*0x39D*/ { "SMSG_UPDATE_COMBO_POINTS",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x39E*/ { "SMSG_VOICE_SESSION_ROSTER_UPDATE", STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x39F*/ { "SMSG_VOICE_SESSION_LEAVE",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3A0*/ { "SMSG_VOICE_SESSION_ADJUST_PRIORITY",STATUS_NEVER,   &WorldSession::Handle_ServerSide               },
    /*0x3A1*/ { "CMSG_VOICE_SET_TALKER_MUTED_REQUEST",STATUS_NEVER,  &WorldSession::Handle_NULL                     },
    /*0x3A2*/ { "SMSG_VOICE_SET_TALKER_MUTED",      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3A3*/ { "SMSG_INIT_EXTRA_AURA_INFO",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3A4*/ { "SMSG_SET_EXTRA_AURA_INFO",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3A5*/ { "SMSG_SET_EXTRA_AURA_INFO_NEED_UPDATE",STATUS_NEVER, &WorldSession::Handle_ServerSide               },
    /*0x3A6*/ { "SMSG_CLEAR_EXTRA_AURA_INFO",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3A7*/ { "MSG_MOVE_START_DESCEND",           STATUS_LOGGEDIN, &WorldSession::HandleMovementOpcodes           },
    /*0x3A8*/ { "CMSG_IGNORE_REQUIREMENTS_CHEAT",   STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3A9*/ { "SMSG_IGNORE_REQUIREMENTS_CHEAT",   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3AA*/ { "SMSG_SPELL_CHANCE_PROC_LOG",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3AB*/ { "CMSG_MOVE_SET_RUN_SPEED",          STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3AC*/ { "SMSG_DISMOUNT",                    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3AD*/ { "MSG_MOVE_UPDATE_CAN_FLY",          STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3AE*/ { "MSG_RAID_READY_CHECK_CONFIRM",     STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3AF*/ { "CMSG_VOICE_SESSION_ENABLE",        STATUS_AUTHED,   &WorldSession::HandleVoiceSettingsOpcode       },
    /*0x3B0*/ { "SMSG_VOICE_PARENTAL_CONTROLS",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3B1*/ { "CMSG_GM_WHISPER",                  STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3B2*/ { "SMSG_GM_MESSAGECHAT",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3B3*/ { "MSG_GM_GEARRATING",                STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3B4*/ { "CMSG_COMMENTATOR_ENABLE",          STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3B5*/ { "SMSG_COMMENTATOR_STATE_CHANGED",   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3B6*/ { "CMSG_COMMENTATOR_GET_MAP_INFO",    STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3B7*/ { "SMSG_COMMENTATOR_MAP_INFO",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3B8*/ { "CMSG_COMMENTATOR_GET_PLAYER_INFO", STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3B9*/ { "SMSG_COMMENTATOR_GET_PLAYER_INFO", STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3BA*/ { "SMSG_COMMENTATOR_PLAYER_INFO",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3BB*/ { "CMSG_COMMENTATOR_ENTER_INSTANCE",  STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3BC*/ { "CMSG_COMMENTATOR_EXIT_INSTANCE",   STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3BD*/ { "CMSG_COMMENTATOR_INSTANCE_COMMAND",STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3BE*/ { "SMSG_CLEAR_TARGET",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3BF*/ { "CMSG_BOT_DETECTED",                STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3C0*/ { "SMSG_CROSSED_INEBRIATION_THRESHOLD",STATUS_NEVER,   &WorldSession::Handle_ServerSide               },
    /*0x3C1*/ { "CMSG_CHEAT_PLAYER_LOGIN",          STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3C2*/ { "CMSG_CHEAT_PLAYER_LOOKUP",         STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3C3*/ { "SMSG_CHEAT_PLAYER_LOOKUP",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3C4*/ { "SMSG_KICK_REASON",                 STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3C5*/ { "MSG_RAID_READY_CHECK_FINISHED",    STATUS_LOGGEDIN, &WorldSession::HandleRaidReadyCheckFinishOpcode},
    /*0x3C6*/ { "CMSG_COMPLAIN",                    STATUS_LOGGEDIN, &WorldSession::HandleReportSpamOpcode          },
    /*0x3C7*/ { "SMSG_COMPLAIN_RESULT",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3C8*/ { "SMSG_FEATURE_SYSTEM_STATUS",       STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3C9*/ { "CMSG_GM_SHOW_COMPLAINTS",          STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3CA*/ { "CMSG_GM_UNSQUELCH",                STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3CB*/ { "CMSG_CHANNEL_SILENCE_VOICE",       STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3CC*/ { "CMSG_CHANNEL_SILENCE_ALL",         STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3CD*/ { "CMSG_CHANNEL_UNSILENCE_VOICE",     STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3CE*/ { "CMSG_CHANNEL_UNSILENCE_ALL",       STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3CF*/ { "CMSG_TARGET_CAST",                 STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3D0*/ { "CMSG_TARGET_SCRIPT_CAST",          STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3D1*/ { "CMSG_CHANNEL_DISPLAY_LIST",        STATUS_LOGGEDIN, &WorldSession::HandleChannelRosterQuery        },
    /*0x3D2*/ { "CMSG_SET_ACTIVE_VOICE_CHANNEL",    STATUS_AUTHED,   &WorldSession::HandleChannelVoiceChatQuery     },
    /*0x3D3*/ { "CMSG_GET_CHANNEL_MEMBER_COUNT",    STATUS_LOGGEDIN, &WorldSession::HandleChannelInfoQuery          },
    /*0x3D4*/ { "SMSG_CHANNEL_MEMBER_COUNT",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3D5*/ { "CMSG_CHANNEL_VOICE_ON",            STATUS_LOGGEDIN, &WorldSession::HandleChannelEnableVoiceOpcode  },
    /*0x3D6*/ { "CMSG_CHANNEL_VOICE_OFF",           STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3D7*/ { "CMSG_DEBUG_LIST_TARGETS",          STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3D8*/ { "SMSG_DEBUG_LIST_TARGETS",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3D9*/ { "SMSG_AVAILABLE_VOICE_CHANNEL",     STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3DA*/ { "CMSG_ADD_VOICE_IGNORE",            STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3DB*/ { "CMSG_DEL_VOICE_IGNORE",            STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3DC*/ { "CMSG_PARTY_SILENCE",               STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3DD*/ { "CMSG_PARTY_UNSILENCE",             STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3DE*/ { "MSG_NOTIFY_PARTY_SQUELCH",         STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3DF*/ { "SMSG_COMSAT_RECONNECT_TRY",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3E0*/ { "SMSG_COMSAT_DISCONNECT",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3E1*/ { "SMSG_COMSAT_CONNECT_FAIL",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3E2*/ { "SMSG_VOICE_CHAT_STATUS",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3E3*/ { "CMSG_REPORT_PVP_AFK",              STATUS_LOGGEDIN, &WorldSession::HandleBattleGroundReportAFK     },
    /*0x3E4*/ { "CMSG_REPORT_PVP_AFK_RESULT",       STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3E5*/ { "CMSG_GUILD_BANKER_ACTIVATE",       STATUS_LOGGEDIN, &WorldSession::HandleGuildBankQuery            },
    /*0x3E6*/ { "CMSG_GUILD_BANK_QUERY_TAB",        STATUS_LOGGEDIN, &WorldSession::HandleGuildBankTabColon         },
    /*0x3E7*/ { "SMSG_GUILD_BANK_LIST",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3E8*/ { "CMSG_GUILD_BANK_SWAP_ITEMS",       STATUS_LOGGEDIN, &WorldSession::HandleGuildBankDepositItem      },
    /*0x3E9*/ { "CMSG_GUILD_BANK_BUY_TAB",          STATUS_LOGGEDIN, &WorldSession::HandleGuildBankBuyTab           },
    /*0x3EA*/ { "CMSG_GUILD_BANK_UPDATE_TAB",       STATUS_LOGGEDIN, &WorldSession::HandleGuildBankModifyTab        },
    /*0x3EB*/ { "CMSG_GUILD_BANK_DEPOSIT_MONEY",    STATUS_LOGGEDIN, &WorldSession::HandleGuildBankDeposit          },
    /*0x3EC*/ { "CMSG_GUILD_BANK_WITHDRAW_MONEY",   STATUS_LOGGEDIN, &WorldSession::HandleGuildBankWithdraw         },
    /*0x3ED*/ { "MSG_GUILD_BANK_LOG_QUERY",         STATUS_LOGGEDIN, &WorldSession::HandleGuildBankLog              },
    /*0x3EE*/ { "CMSG_SET_CHANNEL_WATCH",           STATUS_LOGGEDIN, &WorldSession::HandleChannelJoinNotify         },
    /*0x3EF*/ { "SMSG_USERLIST_ADD",                STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3F0*/ { "SMSG_USERLIST_REMOVE",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3F1*/ { "SMSG_USERLIST_UPDATE",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3F2*/ { "CMSG_CLEAR_CHANNEL_WATCH",         STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3F3*/ { "SMSG_INSPECT_TALENT",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3F4*/ { "SMSG_GOGOGO_OBSOLETE",             STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3F5*/ { "SMSG_ECHO_PARTY_SQUELCH",          STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3F6*/ { "CMSG_SET_TITLE_SUFFIX",            STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3F7*/ { "CMSG_SPELLCLICK",                  STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3F8*/ { "SMSG_LOOT_LIST",                   STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3F9*/ { "CMSG_GM_CHARACTER_RESTORE",        STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3FA*/ { "CMSG_GM_CHARACTER_SAVE",           STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x3FB*/ { "SMSG_VOICESESSION_FULL",           STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x3FC*/ { "MSG_GUILD_PERMISSIONS",            STATUS_LOGGEDIN, &WorldSession::HandleGuildBankGetRights        },
    /*0x3FD*/ { "MSG_GUILD_BANK_MONEY_WITHDRAWN",   STATUS_LOGGEDIN, &WorldSession::HandleGuildBankGetMoneyAmount   },
    /*0x3FE*/ { "MSG_GUILD_EVENT_LOG_QUERY",        STATUS_LOGGEDIN, &WorldSession::HandleGuildEventLogOpcode       },
    /*0x3FF*/ { "CMSG_MAELSTROM_RENAME_GUILD",      STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x400*/ { "CMSG_GET_MIRRORIMAGE_DATA",        STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x401*/ { "SMSG_MIRRORIMAGE_DATA",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x402*/ { "SMSG_FORCE_DISPLAY_UPDATE",        STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x403*/ { "SMSG_SPELL_CHANCE_RESIST_PUSHBACK",STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x404*/ { "CMSG_IGNORE_DIMINISHING_RETURNS_CHEAT",STATUS_NEVER,&WorldSession::Handle_NULL                     },
    /*0x405*/ { "SMSG_IGNORE_DIMINISHING_RETURNS_CHEAT",STATUS_NEVER,&WorldSession::Handle_ServerSide               },
    /*0x406*/ { "CMSG_KEEP_ALIVE",                  STATUS_NEVER,    &WorldSession::Handle_EarlyProccess            },
    /*0x407*/ { "SMSG_RAID_READY_CHECK_ERROR",      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x408*/ { "CMSG_OPT_OUT_OF_LOOT",             STATUS_AUTHED,   &WorldSession::HandleGroupPassOnLootOpcode     },
    /*0x409*/ { "MSG_QUERY_GUILD_BANK_TEXT",        STATUS_LOGGEDIN, &WorldSession::HandleGuildBankTabText          },
    /*0x40A*/ { "CMSG_SET_GUILD_BANK_TEXT",         STATUS_LOGGEDIN, &WorldSession::HandleGuildBankSetTabText       },
    /*0x40B*/ { "CMSG_SET_GRANTABLE_LEVELS",        STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x40C*/ { "CMSG_GRANT_LEVEL",                 STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x40D*/ { "CMSG_REFER_A_FRIEND",              STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x40E*/ { "MSG_GM_CHANGE_ARENA_RATING",       STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x40F*/ { "CMSG_DECLINE_CHANNEL_INVITE",      STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x410*/ { "CMSG_GROUPACTION_THROTTLED",       STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x411*/ { "SMSG_OVERRIDE_LIGHT",              STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x412*/ { "SMSG_TOTEM_CREATED",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x413*/ { "CMSG_TOTEM_DESTROYED",             STATUS_LOGGEDIN, &WorldSession::HandleTotemDestroy              },
    /*0x414*/ { "CMSG_EXPIRE_RAID_INSTANCE",        STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x415*/ { "CMSG_NO_SPELL_VARIANCE",           STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x416*/ { "CMSG_QUESTGIVER_STATUS_MULTIPLE_QUERY",STATUS_LOGGEDIN,&WorldSession::HandleQuestgiverStatusQueryMultipleOpcode},
    /*0x417*/ { "SMSG_QUESTGIVER_STATUS_MULTIPLE",  STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x418*/ { "CMSG_SET_PLAYER_DECLINED_NAMES",   STATUS_AUTHED,   &WorldSession::HandleDeclinedPlayerNameOpcode  },
    /*0x419*/ { "SMSG_SET_PLAYER_DECLINED_NAMES_RESULT",STATUS_NEVER,&WorldSession::Handle_ServerSide               },
    /*0x41A*/ { "CMSG_QUERY_SERVER_BUCK_DATA",      STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x41B*/ { "CMSG_CLEAR_SERVER_BUCK_DATA",      STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x41C*/ { "SMSG_SERVER_BUCK_DATA",            STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x41D*/ { "SMSG_SEND_UNLEARN_SPELLS",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x41E*/ { "SMSG_PROPOSE_LEVEL_GRANT",         STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x41F*/ { "CMSG_ACCEPT_LEVEL_GRANT",          STATUS_NEVER,    &WorldSession::Handle_NULL                     },
    /*0x420*/ { "SMSG_REFER_A_FRIEND_FAILURE",      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x421*/ { "SMSG_SPLINE_MOVE_SET_FLYING",      STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x422*/ { "SMSG_SPLINE_MOVE_UNSET_FLYING",    STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
    /*0x423*/ { "SMSG_SUMMON_CANCEL",               STATUS_NEVER,    &WorldSession::Handle_ServerSide               },
};
