/* Copyright (C) 2006 - 2008 ScriptDev2 <https://scriptdev2.svn.sourceforge.net/>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/* ScriptData
SDName: Boss_Noth
SD%Complete: 40
SDComment: Missing Balcony stage
SDCategory: Naxxramas
EndScriptData */

#include "precompiled.h"

#define SAY_AGGRO1 "Glory to the master!"
#define SAY_AGGRO2 "Your life is forfeit!"
#define SAY_AGGRO3 "Die, trespasser!"
#define SAY_SUMMON "Rise, my soldiers! Rise and fight once more!"
#define SAY_SLAY1 "My task is done!"
#define SAY_SLAY2 "Breathe no more!"
#define SAY_DEATH "I will serve the master... in... death!"
#define SOUND_AGGRO1      8845
#define SOUND_AGGRO2      8846
#define SOUND_AGGRO3      8847
#define SOUND_SUMMON      8851
#define SOUND_SLAY1      8849
#define SOUND_SLAY2      8850
#define SOUND_DEATH      8848

// Teleport position of Noth on his balcony
#define TELE_X 2631.370
#define TELE_Y -3529.680
#define TELE_Z 274.040
#define TELE_O 6.277

#define SPELL_BLINK                           29211
#define SPELL_CRIPPLE                         29212
#define SPELL_CURSEPLAGUEBRINGER              28213
#define SPELL_WRATHPLAGUEBRINGER              28214

// IMPORTANT: BALCONY TELEPORT NOT ADDED YET! WILL BE ADDED SOON!

struct TRINITY_DLL_DECL boss_nothAI : public ScriptedAI
{
    boss_nothAI(Creature *c) : ScriptedAI(c) {Reset();}

    uint32 Blink_Timer;
    uint32 Curse_Timer;
    uint32 Wrath_Timer;
    uint32 Summon_Timer;

    void Reset()
    {
        Blink_Timer = 25000;
        Curse_Timer = 4000;
        Wrath_Timer = 9000;
        Summon_Timer = 12000;
    }

    void Aggro(Unit *who)
    {
        switch (rand()%3)
        {
            case 0:
                DoYell(SAY_AGGRO1,LANG_UNIVERSAL,NULL);
                DoPlaySoundToSet(m_creature,SOUND_AGGRO1);
                break;
            case 1:
                DoYell(SAY_AGGRO2,LANG_UNIVERSAL,NULL);
                DoPlaySoundToSet(m_creature,SOUND_AGGRO2);
                break;
            case 2:
                DoYell(SAY_AGGRO3,LANG_UNIVERSAL,NULL);
                DoPlaySoundToSet(m_creature,SOUND_AGGRO3);
                break;
        }
    }

    void KilledUnit(Unit* victim)
    {
        switch (rand()%2)
        {
            case 0:
                DoYell(SAY_SLAY1,LANG_UNIVERSAL,NULL);
                DoPlaySoundToSet(m_creature,SOUND_SLAY1);
                break;
            case 1:
                DoYell(SAY_SLAY2,LANG_UNIVERSAL,NULL);
                DoPlaySoundToSet(m_creature,SOUND_SLAY2);
                break;
        }
    }

    void JustDied(Unit* Killer)
    {
        DoYell(SAY_DEATH,LANG_UNIVERSAL,NULL);
        DoPlaySoundToSet(m_creature,SOUND_DEATH);
    }

    void UpdateAI(const uint32 diff)
    {
        if (!m_creature->SelectHostilTarget() || !m_creature->getVictim())
            return;

        //Blink_Timer
        if (Blink_Timer < diff)
        {
            DoCast(m_creature->getVictim(),SPELL_CRIPPLE);
            DoCast(m_creature,SPELL_BLINK);

            Blink_Timer = 25000;
        }else Blink_Timer -= diff;

        //Curse_Timer
        if (Curse_Timer < diff)
        {
            DoCast(m_creature->getVictim(),SPELL_CURSEPLAGUEBRINGER);
            Curse_Timer = 28000;
        }else Curse_Timer -= diff;

        //Wrath_Timer
        if (Wrath_Timer < diff)
        {
            DoCast(m_creature->getVictim(),SPELL_WRATHPLAGUEBRINGER);
            Wrath_Timer = 18000;
        }else Wrath_Timer -= diff;

        //Summon_Timer
        if (Summon_Timer < diff)
        {
            DoYell(SAY_SUMMON,LANG_UNIVERSAL,NULL);
            DoPlaySoundToSet(m_creature,SOUND_SUMMON);

            Unit* target = NULL;
            Unit* SummonedSkeletons = NULL;

            SummonedSkeletons = m_creature->SummonCreature(16984,2684.804,-3502.517,261.313,0,TEMPSUMMON_TIMED_OR_DEAD_DESPAWN,80000);
            SummonedSkeletons = m_creature->SummonCreature(16984,2684.804,-3502.517,261.313,0,TEMPSUMMON_TIMED_OR_DEAD_DESPAWN,80000);
            SummonedSkeletons = m_creature->SummonCreature(16984,2684.804,-3502.517,261.313,0,TEMPSUMMON_TIMED_OR_DEAD_DESPAWN,80000);
            SummonedSkeletons = m_creature->SummonCreature(16984,2684.804,-3502.517,261.313,0,TEMPSUMMON_TIMED_OR_DEAD_DESPAWN,80000);
            SummonedSkeletons = m_creature->SummonCreature(16984,2684.804,-3502.517,261.313,0,TEMPSUMMON_TIMED_OR_DEAD_DESPAWN,80000);
            SummonedSkeletons = m_creature->SummonCreature(16984,2684.804,-3502.517,261.313,0,TEMPSUMMON_TIMED_OR_DEAD_DESPAWN,80000);

            if (SummonedSkeletons)
            {
                target = SelectUnit(SELECT_TARGET_RANDOM,0);
                if (target)
                    SummonedSkeletons->AddThreat(target,1.0f);
            }

            Summon_Timer = 30500;
        } else Summon_Timer -= diff;

        DoMeleeAttackIfReady();
    }
};
CreatureAI* GetAI_boss_noth(Creature *_Creature)
{
    return new boss_nothAI (_Creature);
}

void AddSC_boss_noth()
{
    Script *newscript;
    newscript = new Script;
    newscript->Name="boss_noth";
    newscript->GetAI = GetAI_boss_noth;
    m_scripts[nrscripts++] = newscript;
}
