/* Copyright (C) 2006 - 2008 ScriptDev2 <https://scriptdev2.svn.sourceforge.net/>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/* ScriptData
SDName: Boss_Ambassador_Hellmaw
SD%Complete: 75
SDComment: Waypoints after Intro not implemented. Enrage spell missing/not known
SDCategory: Auchindoun, Shadow Labyrinth
EndScriptData */

#include "precompiled.h"
#include "def_shadow_labyrinth.h"

#define SAY_INTRO       "Infidels have invaded the sanctuary! Sniveling pests...You have yet to learn the true meaning of agony!"
#define SOUND_INTRO     10473

#define SAY_AGGRO1      "Pathetic mortals! You will pay dearly!"
#define SOUND_AGGRO1    10475
#define SAY_AGGRO2      "I will break you!"
#define SOUND_AGGRO2    10476
#define SAY_AGGRO3      "Finally! Something to relieve the tedium!"
#define SOUND_AGGRO3    10477

#define SAY_HELP        "Aid me, you fools, before it's too late!"
#define SOUND_HELP      10474

#define SAY_SLAY1       "Do you fear death?"
#define SOUND_SLAY1     10478
#define SAY_SLAY2       "This is the part I enjoy most."
#define SOUND_SLAY2     10479

#define SAY_DEATH       "Do not...grow...overconfident, mortal."
#define SOUND_DEATH     10480

#define SPELL_BANISH            30231
#define SPELL_CORROSIVE_ACID    23313
#define SPELL_FEAR              33547
#define SPELL_ENRAGE            0                           //need to find proper spell

struct TRINITY_DLL_DECL boss_ambassador_hellmawAI : public ScriptedAI
{
    boss_ambassador_hellmawAI(Creature *c) : ScriptedAI(c)
    {
        pInstance = ((ScriptedInstance*)c->GetInstanceData());
        Reset();
    }

    ScriptedInstance* pInstance;
    bool HeroicMode;

    uint32 EventCheck_Timer;
    uint32 CorrosiveAcid_Timer;
    uint32 Fear_Timer;
    uint32 Enrage_Timer;
    bool Intro;
    bool IsBanished;

    void Reset()
    {
        HeroicMode = m_creature->GetMap()->IsHeroic();

        EventCheck_Timer = 5000;
        CorrosiveAcid_Timer = 25000;
        Fear_Timer = 40000;
        Enrage_Timer = 180000;
        Intro = false;
        IsBanished = false;

        if( pInstance )
        {
            if( pInstance->GetData(TYPE_HELLMAW) == NOT_STARTED )
            {
                DoCast(m_creature,SPELL_BANISH);
                IsBanished = true;
            }
            else pInstance->SetData(TYPE_HELLMAW,FAIL);

            if( pInstance->GetData(TYPE_OVERSEER) == DONE )
            {
                if( m_creature->HasAura(SPELL_BANISH,0) )
                    m_creature->RemoveAurasDueToSpell(SPELL_BANISH);
                Intro = true;
            }
        }
    }

    void MovementInform(uint32 type, uint32 id)
    {
        if( type != POINT_MOTION_TYPE )
            return;
    }

    void DoIntro()
    {
        DoYell(SAY_INTRO, LANG_UNIVERSAL, NULL);
        DoPlaySoundToSet(m_creature, SOUND_INTRO);

        if( m_creature->HasAura(SPELL_BANISH,0) )
            m_creature->RemoveAurasDueToSpell(SPELL_BANISH);

        IsBanished = false;
        Intro = true;

        if( pInstance )
            pInstance->SetData(TYPE_HELLMAW, IN_PROGRESS);
    }

    void Aggro(Unit *who)
    {
        switch(rand()%3)
        {
            case 0:
                DoYell(SAY_AGGRO1, LANG_UNIVERSAL, NULL);
                DoPlaySoundToSet(m_creature, SOUND_AGGRO1);
                break;
            case 1:
                DoYell(SAY_AGGRO2, LANG_UNIVERSAL, NULL);
                DoPlaySoundToSet(m_creature, SOUND_AGGRO2);
                break;
            case 2:
                DoYell(SAY_AGGRO3, LANG_UNIVERSAL, NULL);
                DoPlaySoundToSet(m_creature, SOUND_AGGRO3);
                break;
        }
    }

    void KilledUnit(Unit *victim)
    {
        switch(rand()%2)
        {
            case 0:
                DoYell(SAY_SLAY1, LANG_UNIVERSAL, NULL);
                DoPlaySoundToSet(m_creature, SOUND_SLAY1);
                break;
            case 1:
                DoYell(SAY_SLAY2, LANG_UNIVERSAL, NULL);
                DoPlaySoundToSet(m_creature, SOUND_SLAY2);
                break;
        }
    }

    void JustDied(Unit *victim)
    {
        DoYell(SAY_DEATH, LANG_UNIVERSAL, NULL);
        DoPlaySoundToSet(m_creature, SOUND_DEATH);

        if( pInstance )
            pInstance->SetData(TYPE_HELLMAW, DONE);
    }

    void UpdateAI(const uint32 diff)
    {
        if( !Intro )
        {
            if( EventCheck_Timer < diff )
            {
                if( pInstance )
                {
                    if( pInstance->GetData(TYPE_OVERSEER) == DONE )
                        DoIntro();
                }
                EventCheck_Timer = 5000;
            }else EventCheck_Timer -= diff;
        }

        if( !InCombat && !IsBanished )
        {
            //this is where we add MovePoint()
            //DoWhine("I haz no mount!", LANG_UNIVERSAL, NULL);
        }

        if (!m_creature->SelectHostilTarget() || !m_creature->getVictim() )
            return;

        if( CorrosiveAcid_Timer < diff )
        {
            DoCast(m_creature,SPELL_CORROSIVE_ACID);
            CorrosiveAcid_Timer = 25000;
        }else CorrosiveAcid_Timer -= diff;

        if( Fear_Timer < diff )
        {
            DoCast(m_creature,SPELL_FEAR);
            Fear_Timer = 35000;
        }else Fear_Timer -= diff;

        /*if( HeroicMode )
        {
            if( Enrage_Timer < diff )
            {
                DoCast(m_creature,SPELL_ENRAGE);
            }else Enrage_Timer -= diff;
        }*/

        DoMeleeAttackIfReady();
    }
};
CreatureAI* GetAI_boss_ambassador_hellmaw(Creature *_Creature)
{
    return new boss_ambassador_hellmawAI (_Creature);
}

void AddSC_boss_ambassador_hellmaw()
{
    Script *newscript;
    newscript = new Script;
    newscript->Name="boss_ambassador_hellmaw";
    newscript->GetAI = GetAI_boss_ambassador_hellmaw;
    m_scripts[nrscripts++] = newscript;
}
